
/*
 *  mtp is the ``Multi Tracked Paths'', an implementation of the
 *  k-shortest paths algorithm for multi-target tracking.
 *
 *  Copyright (c) 2012 Idiap Research Institute, http://www.idiap.ch/
 *  Written by Francois Fleuret <francois.fleuret@idiap.ch>
 *
 *  This file is part of mtp.
 *
 *  mtp is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  mtp is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 *  License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with selector.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <iostream>
#include <fstream>

using namespace std;

#include "mtp_tracker.h"

int main(int argc, char **argv) {

  if(argc < 2) {
    cerr << argv[0] << " <tracker file>" << endl;
    exit(EXIT_FAILURE);
  }

  ifstream *in_tracker = new ifstream(argv[1]);

  if(in_tracker->good()) {

    MTPTracker *tracker = new MTPTracker();

    tracker->read(in_tracker);
    cout << "Read " << argv[1] << endl;

    tracker->build_graph();
    tracker->track();

    ofstream out_traj("result.trj");
    tracker->write_trajectories(&out_traj);
    cout << "Wrote result.trj" << endl;

    ofstream out_dot("graph.dot");
    tracker->print_graph_dot(&out_dot);
    cout << "Wrote graph.dot" << endl;

    delete tracker;

  } else {

    cerr << "Can not open " << argv[1] << endl;
    exit(EXIT_FAILURE);

  }

  delete in_tracker;

  exit(EXIT_SUCCESS);
}
