"""
Copyright (c) 2011 Idiap Research Institute, http://www.idiap.ch/
Written by Carl Scheffler <carl.scheffler@gmail.com>

This file is part of FaceColorModel.

FaceColorModel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License version 3 as
published by the Free Software Foundation.

FaceColorModel is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with FaceColorModel. If not, see <http://www.gnu.org/licenses/>.
"""
from __future__ import division
from scipy import *
import os, sys

conditions = [
    {'kmrf': 0, 'skin': 'cont', 'hair': 'cont'},
    {'kmrf': 1, 'skin': 'cont', 'hair': 'cont'},
    {'kmrf': 2, 'skin': 'cont', 'hair': 'cont'},
    {'kmrf': 3, 'skin': 'cont', 'hair': 'cont'},
    {'kmrf': 4, 'skin': 'cont', 'hair': 'cont'},
    {'kmrf': 5, 'skin': 'cont', 'hair': 'cont'},
    {'kmrf': 6, 'skin': 'cont', 'hair': 'cont'},
    {'kmrf': 0, 'skin': 'disc', 'hair': 'disc'},
    {'kmrf': 1, 'skin': 'disc', 'hair': 'disc'},
    {'kmrf': 2, 'skin': 'disc', 'hair': 'disc'},
    {'kmrf': 3, 'skin': 'disc', 'hair': 'disc'},
    {'kmrf': 4, 'skin': 'disc', 'hair': 'disc'},
    {'kmrf': 5, 'skin': 'disc', 'hair': 'disc'},
    {'kmrf': 6, 'skin': 'disc', 'hair': 'disc'},
]

classes = ['skin','hair','clothes','background']
verbose = False
resultsFilename = 'results_mrf.txt'
numFolds = 5

# Clear results file
with open(resultsFilename, 'wt') as fp:
    fp.write("results = {\n")
    
accuracy = {}
for modelType in ['cont', 'disc']:
    accuracy[modelType] = []
    for kMrf in range(7):
        print 'Running experiment for MRF field strength %i and %s color distribution'%(kMrf, modelType)
        os.system("python run_experiment.py --folds %i "%numFolds +\
                  " --kmrf %i"%kMrf +\
                  " --skin %s --hair %s"%(modelType, modelType) +\
                  " --quiet" +\
                  " > __experiment_results.txt")
        with open('__experiment_results.txt','rt') as fp:
            resultString = fp.read().strip()
            subString = "Overall accuracy: "
            pos = resultString.find(subString)
            if pos == -1:
                print 'Fatal error in experiment output: aborting'
                sys.exit()
            pos += len(subString)
            accuracy[modelType].append(float(resultString[pos:]))
        print 'Accuracy: %f'%accuracy[modelType][-1]

    with open(resultsFilename, 'at') as fp:
        fp.write("  '%s': ["%modelType + ", ".join(["%.3f"%x for x in accuracy[modelType]]) + "],\n")

with open(resultsFilename, 'at') as fp:
    fp.write("}\n")

os.unlink('__experiment_results.txt')

import pylab

pylab.figure()
for modelType in accuracy:
    pylab.plot(accuracy[modelType], 'o-', label=modelType)
pylab.legend(loc='lower right')

pylab.show()
