"""
Plot the prior probability that each pixel in the face box belongs to
the skin, hair, clothing or background class.

Copyright (c) 2011 Idiap Research Institute, http://www.idiap.ch/
Written by Carl Scheffler <carl.scheffler@gmail.com>

This file is distributed as part of FaceColorModel.

FaceColorModel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License version 3 as
published by the Free Software Foundation.

FaceColorModel is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with FaceColorModel. If not, see <http://www.gnu.org/licenses/>.
"""
from __future__ import division
from scipy import *
from scipy import stats
import pylab
from gamma import scipy_gamma_samples, scipy_gamma_distribution
from colorlib import ypbpr2rgb

LATEX = False
SAVE_PLOTS = False

if LATEX:
    LATEX_FIGURE_FACTOR = 0.22 # [1]

    LATEX_TEXT_WIDTH = 367.32089 # [pt]
    LATEX_FIGURE_WIDTH = LATEX_FIGURE_FACTOR * LATEX_TEXT_WIDTH # [pt]
    LATEX_PT_PER_INCH = 72.27 # [pt/inch]

    FIGURE_WIDTH = LATEX_FIGURE_WIDTH/LATEX_PT_PER_INCH
    GOLDEN_RATIO = (sqrt(5)-1)/2

    rc_params = {
        'figure.figsize': (FIGURE_WIDTH, 1.0*FIGURE_WIDTH),
        'axes.labelsize': 10,
        'text.fontsize': 10,
        'font.size': 8,
        'legend.fontsize': 8,
        'xtick.labelsize': 8,
        'ytick.labelsize': 8,
        'figure.subplot.bottom': 0,
        'figure.subplot.top': 1,
        'figure.subplot.left': 0,
        'figure.subplot.right': 1,
        'text.usetex': True,
        'lines.linewidth': 1*LATEX_FIGURE_FACTOR,
        'lines.markersize': 6*LATEX_FIGURE_FACTOR,
    }
    pylab.rcParams.update(rc_params)

from FaceColorModelWrapper import FCM_SCALED_SIZE as scaledSize
CHANNELS = ['skin', 'hair', 'clothes', 'background']

with open('storage/pim_prior.data','rb') as fp:
    pim = reshape(fromstring(fp.read(), dtype=float),
                  (len(CHANNELS), scaledSize, scaledSize))
for i in range(len(CHANNELS)):
    channel = CHANNELS[i]
    pylab.figure()
    pylab.imshow(1-pim[i], interpolation='nearest', vmin=0, vmax=1)
    pylab.gray()
    pylab.xticks([])
    pylab.yticks([])
    if SAVE_PLOTS:
        pylab.savefig('figures/pim_prior_%s.pdf'%channel)
    pylab.title(channel)

pylab.show()
