/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.sst;

import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.CoordinateIterator;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.genericmatrix.stub.AbstractDenseGenericMatrix;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.util.MathUtil;
import shared.array.ObjectArray;

public class SSTDenseObjectMatrix
extends AbstractDenseGenericMatrix<Object>
implements Wrapper<ObjectArray<Object>> {
    private static final long serialVersionUID = 2319673263310965476L;
    private transient ObjectArray<Object> data = null;

    public SSTDenseObjectMatrix(ObjectArray<Object> data) {
        this.data = data;
    }

    public SSTDenseObjectMatrix(long ... size) {
        this.data = new ObjectArray(Object.class, MathUtil.toIntArray(size));
    }

    public SSTDenseObjectMatrix(Matrix source) {
        this.data = new ObjectArray(Object.class, MathUtil.toIntArray(source.getSize()));
        for (long[] c : source.availableCoordinates()) {
            this.setObject(source.getAsObject(c), c);
        }
    }

    @Override
    public Object getObject(long ... coordinates) throws MatrixException {
        return this.data.get(MathUtil.toIntArray(coordinates));
    }

    @Override
    public void setObject(Object value, long ... coordinates) throws MatrixException {
        this.data.set(value, MathUtil.toIntArray(coordinates));
    }

    @Override
    public long[] getSize() {
        return MathUtil.toLongArray(this.data.dimensions());
    }

    @Override
    public Iterable<long[]> allCoordinates() throws MatrixException {
        return new CoordinateIterator(this.getSize());
    }

    @Override
    public ObjectArray<Object> getWrappedObject() {
        return this.data;
    }

    @Override
    public void setWrappedObject(ObjectArray<Object> object) {
        this.data = object;
    }
}

