/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.orbital;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import orbital.math.Arithmetic;
import orbital.math.LUDecomposition;
import orbital.math.Matrix;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Values;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbitalDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<Matrix> {
    private static final long serialVersionUID = 3094717557850722162L;
    private transient Matrix matrix = null;

    public OrbitalDenseDoubleMatrix2D(long ... size) {
        this.matrix = Values.getDefault().ZERO((int)size[0], (int)size[1]);
    }

    public OrbitalDenseDoubleMatrix2D(org.ujmp.core.Matrix m) {
        this(m.getSize());
        for (long[] c : m.allCoordinates()) {
            this.setAsDouble(m.getAsDouble(c), c);
        }
    }

    public OrbitalDenseDoubleMatrix2D(Matrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public double getDouble(int row, int column) {
        return ((Real)this.matrix.get(row, column)).doubleValue();
    }

    @Override
    public double getDouble(long row, long column) {
        return ((Real)this.matrix.get((int)row, (int)column)).doubleValue();
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.dimensions()[0], this.matrix.dimensions()[1]};
    }

    @Override
    public Matrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public org.ujmp.core.Matrix mtimes(org.ujmp.core.Matrix m) {
        if (m instanceof OrbitalDenseDoubleMatrix2D) {
            Matrix mo = ((OrbitalDenseDoubleMatrix2D)m).getWrappedObject();
            Matrix result = this.matrix.multiply(mo);
            return new OrbitalDenseDoubleMatrix2D(result);
        }
        return super.mtimes(m);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.set(row, column, (Arithmetic)Values.getDefault().valueOf(value));
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.set((int)row, (int)column, (Arithmetic)Values.getDefault().valueOf(value));
    }

    @Override
    public void setWrappedObject(Matrix object) {
        this.matrix = object;
    }

    @Override
    public org.ujmp.core.Matrix plus(org.ujmp.core.Matrix m) {
        if (m instanceof OrbitalDenseDoubleMatrix2D) {
            Matrix result = this.matrix.add(((OrbitalDenseDoubleMatrix2D)m).matrix);
            return new OrbitalDenseDoubleMatrix2D(result);
        }
        return super.plus(m);
    }

    @Override
    public org.ujmp.core.Matrix times(double v) {
        Matrix result = this.matrix.scale((Scalar)Values.getDefault().valueOf(v));
        return new OrbitalDenseDoubleMatrix2D(result);
    }

    @Override
    public org.ujmp.core.Matrix divide(double v) {
        Matrix result = this.matrix.scale((Scalar)Values.getDefault().valueOf(1.0 / v));
        return new OrbitalDenseDoubleMatrix2D(result);
    }

    @Override
    public org.ujmp.core.Matrix minus(org.ujmp.core.Matrix m) {
        if (m instanceof OrbitalDenseDoubleMatrix2D) {
            Matrix result = this.matrix.subtract(((OrbitalDenseDoubleMatrix2D)m).matrix);
            return new OrbitalDenseDoubleMatrix2D(result);
        }
        return super.minus(m);
    }

    @Override
    public org.ujmp.core.Matrix transpose() {
        return new OrbitalDenseDoubleMatrix2D(this.matrix.transpose());
    }

    @Override
    public org.ujmp.core.Matrix inv() {
        return new OrbitalDenseDoubleMatrix2D((Matrix)this.matrix.inverse());
    }

    @Override
    public org.ujmp.core.Matrix[] lu() {
        if (this.isSquare()) {
            LUDecomposition lu = LUDecomposition.decompose((Matrix)this.matrix);
            OrbitalDenseDoubleMatrix2D l = new OrbitalDenseDoubleMatrix2D(lu.getL());
            OrbitalDenseDoubleMatrix2D u = new OrbitalDenseDoubleMatrix2D(lu.getU());
            OrbitalDenseDoubleMatrix2D p = new OrbitalDenseDoubleMatrix2D(lu.getP());
            return new org.ujmp.core.Matrix[]{l, u, p};
        }
        throw new MatrixException("only square matrices allowed");
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        double[][] data = (double[][])s.readObject();
        int rows = data.length;
        int cols = data[0].length;
        this.matrix = Values.getDefault().ZERO(rows, cols);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                this.setDouble(data[r][c], r, c);
                ++c;
            }
            ++r;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.toDoubleArray());
    }
}

