/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.mail;

import java.io.IOException;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageMatrix
extends DefaultMapMatrix<Object, Object> {
    private static final long serialVersionUID = 4973660519646290182L;

    public MessageMatrix(Message m) throws IOException, MessagingException {
        this.put("Content", m.getContent());
        this.put("ContentType", m.getContentType());
        this.put("Description", m.getDescription());
        this.put("Disposition", m.getDisposition());
        this.put("FileName", m.getFileName());
        this.put("SentDate", m.getSentDate());
        this.put("Subject", m.getSubject());
        this.put("Folder", m.getFolder());
        this.put("ReceivedDate", m.getReceivedDate());
        Flags flags = m.getFlags();
        DefaultListMatrix<String> flagMatrix = new DefaultListMatrix<String>(flags.getUserFlags());
        this.put("Flags", flagMatrix);
        Enumeration headers = m.getAllHeaders();
        DefaultListMatrix headerMatrix = new DefaultListMatrix();
        while (headers.hasMoreElements()) {
            headerMatrix.add(headers.nextElement());
        }
        this.put("AllHeaders", headerMatrix);
        Address[] recipients = m.getAllRecipients();
        DefaultListMatrix recipientsMatrix = new DefaultListMatrix();
        Address[] addressArray = recipients;
        int n = recipients.length;
        int n2 = 0;
        while (n2 < n) {
            Address a = addressArray[n2];
            recipientsMatrix.add("" + a);
            ++n2;
        }
        this.put("AllRecipients", recipientsMatrix);
        Address[] from = m.getFrom();
        DefaultListMatrix fromMatrix = new DefaultListMatrix();
        Address[] addressArray2 = from;
        int n3 = from.length;
        int n4 = 0;
        while (n4 < n3) {
            Address a = addressArray2[n4];
            fromMatrix.add("" + a);
            ++n4;
        }
        this.put("From", fromMatrix);
        Address[] replyTo = m.getReplyTo();
        DefaultListMatrix replyToMatrix = new DefaultListMatrix();
        Address[] addressArray3 = replyTo;
        int n5 = replyTo.length;
        int n6 = 0;
        while (n6 < n5) {
            Address a = addressArray3[n6];
            replyToMatrix.add("" + a);
            ++n6;
        }
        this.put("ReplyTo", replyToMatrix);
    }
}

