/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jmatrices;

import org.jmatrices.dbl.Matrix;
import org.jmatrices.dbl.MatrixFactory;
import org.jmatrices.dbl.decomposition.CholeskyDecomposition;
import org.jmatrices.dbl.decomposition.EigenvalueDecomposition;
import org.jmatrices.dbl.decomposition.LUDecomposition;
import org.jmatrices.dbl.decomposition.QRDecomposition;
import org.jmatrices.dbl.decomposition.SingularValueDecomposition;
import org.jmatrices.dbl.operator.MatrixOperator;
import org.jmatrices.dbl.transformer.MatrixTransformer;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMatricesDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<Matrix> {
    private static final long serialVersionUID = 513251881654621L;
    private Matrix matrix = null;

    public JMatricesDenseDoubleMatrix2D(Matrix matrix) {
        this.matrix = matrix;
    }

    public JMatricesDenseDoubleMatrix2D(long ... size) {
        if (size[0] > 0L && size[1] > 0L) {
            this.matrix = MatrixFactory.getMatrix((int)((int)size[0]), (int)((int)size[1]), null);
        }
    }

    public JMatricesDenseDoubleMatrix2D(org.ujmp.core.Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setAsDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.get((int)row + 1, (int)column + 1);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.get(row + 1, column + 1);
    }

    @Override
    public long[] getSize() {
        long[] lArray;
        if (this.matrix == null) {
            lArray = Coordinates.ZERO2D;
        } else {
            long[] lArray2 = new long[2];
            lArray2[0] = this.matrix.rows();
            lArray = lArray2;
            lArray2[1] = this.matrix.cols();
        }
        return lArray;
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.set((int)row + 1, (int)column + 1, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.set(row + 1, column + 1, value);
    }

    @Override
    public Matrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(Matrix object) {
        this.matrix = object;
    }

    @Override
    public org.ujmp.core.Matrix transpose() {
        return new JMatricesDenseDoubleMatrix2D(MatrixTransformer.transpose((Matrix)this.matrix));
    }

    @Override
    public org.ujmp.core.Matrix inv() {
        return new JMatricesDenseDoubleMatrix2D(MatrixTransformer.inverse((Matrix)this.matrix));
    }

    @Override
    public org.ujmp.core.Matrix[] eig() {
        EigenvalueDecomposition evd = new EigenvalueDecomposition(this.matrix);
        JMatricesDenseDoubleMatrix2D v = new JMatricesDenseDoubleMatrix2D(evd.getV());
        JMatricesDenseDoubleMatrix2D d = new JMatricesDenseDoubleMatrix2D(evd.getD());
        return new org.ujmp.core.Matrix[]{v, d};
    }

    @Override
    public org.ujmp.core.Matrix[] qr() {
        if (this.getRowCount() >= this.getColumnCount()) {
            QRDecomposition qr = new QRDecomposition(this.matrix);
            JMatricesDenseDoubleMatrix2D q = new JMatricesDenseDoubleMatrix2D(qr.getQ());
            JMatricesDenseDoubleMatrix2D r = new JMatricesDenseDoubleMatrix2D(qr.getR());
            return new org.ujmp.core.Matrix[]{q, r};
        }
        throw new MatrixException("only allowed for matrices m>=n");
    }

    @Override
    public org.ujmp.core.Matrix[] svd() {
        if (this.isSquare()) {
            SingularValueDecomposition qr = new SingularValueDecomposition(this.matrix);
            JMatricesDenseDoubleMatrix2D u = new JMatricesDenseDoubleMatrix2D(qr.getU());
            JMatricesDenseDoubleMatrix2D s = new JMatricesDenseDoubleMatrix2D(qr.getS());
            JMatricesDenseDoubleMatrix2D v = new JMatricesDenseDoubleMatrix2D(qr.getV());
            return new org.ujmp.core.Matrix[]{u, s, v};
        }
        throw new MatrixException("only allowed for square matrices");
    }

    @Override
    public org.ujmp.core.Matrix chol() {
        CholeskyDecomposition chol = new CholeskyDecomposition(this.matrix);
        JMatricesDenseDoubleMatrix2D r = new JMatricesDenseDoubleMatrix2D(chol.getL());
        return r;
    }

    @Override
    public org.ujmp.core.Matrix[] lu() {
        if (this.getRowCount() >= this.getColumnCount()) {
            LUDecomposition lu = new LUDecomposition(this.matrix);
            JMatricesDenseDoubleMatrix2D l = new JMatricesDenseDoubleMatrix2D(lu.getL());
            JMatricesDenseDoubleMatrix2D u = new JMatricesDenseDoubleMatrix2D(lu.getU().getSubMatrix(1, 1, (int)this.getColumnCount(), (int)this.getColumnCount()));
            int m = (int)this.getRowCount();
            int[] piv = lu.getPivot();
            JMatricesDenseDoubleMatrix2D p = new JMatricesDenseDoubleMatrix2D(m, m);
            int i = 0;
            while (i < m) {
                p.setAsDouble(1.0, new long[]{i, piv[i] - 1});
                ++i;
            }
            return new org.ujmp.core.Matrix[]{l, u, p};
        }
        throw new MatrixException("only allowed for matrices m>=n");
    }

    @Override
    public org.ujmp.core.Matrix mtimes(org.ujmp.core.Matrix m2) {
        if (m2 instanceof JMatricesDenseDoubleMatrix2D) {
            return new JMatricesDenseDoubleMatrix2D(MatrixOperator.multiply((Matrix)this.matrix, (Matrix)((JMatricesDenseDoubleMatrix2D)m2).matrix));
        }
        return super.mtimes(m2);
    }

    @Override
    public org.ujmp.core.Matrix solve(org.ujmp.core.Matrix b) {
        if (b instanceof JMatricesDenseDoubleMatrix2D) {
            JMatricesDenseDoubleMatrix2D b2 = (JMatricesDenseDoubleMatrix2D)b;
            if (this.isSquare()) {
                Matrix x = new LUDecomposition(this.matrix).solve(b2.matrix);
                return new JMatricesDenseDoubleMatrix2D(x);
            }
            Matrix x = new QRDecomposition(this.matrix).solve(b2.matrix);
            return new JMatricesDenseDoubleMatrix2D(x);
        }
        return super.solve(b);
    }
}

