/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix;

public class JDBCSparseObjectMatrix
extends AbstractSparseObjectMatrix
implements Closeable {
    private static final long serialVersionUID = -5801269687893136766L;
    private Connection connection = null;
    private PreparedStatement getEntryStatement = null;
    private PreparedStatement insertEntryStatement = null;
    private PreparedStatement deleteEntryStatement = null;
    private PreparedStatement getSizeStatement = null;
    private String url = null;
    private String username = null;
    private String password = null;
    private String tableName = null;
    private String[] columnsForCoordinates = null;
    private String columnForValue = null;
    private long[] size = null;

    public JDBCSparseObjectMatrix(String url, String username, String password, String tableName, String columnForValue, String ... columnsForCoordinates) throws ClassNotFoundException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.tableName = tableName;
        this.columnForValue = columnForValue;
        this.columnsForCoordinates = columnsForCoordinates;
    }

    private PreparedStatement getGetEntryStatement() {
        try {
            if (this.getEntryStatement == null) {
                StringBuilder s = new StringBuilder();
                s.append("select ");
                s.append(this.columnForValue);
                s.append(" from ");
                s.append(this.tableName);
                s.append(" where ");
                int i = 0;
                while (i < this.columnsForCoordinates.length) {
                    s.append(this.columnsForCoordinates[i]);
                    s.append("=?");
                    if (i < this.columnsForCoordinates.length - 1) {
                        s.append(" and ");
                    }
                    ++i;
                }
                this.getEntryStatement = this.getConnection().prepareStatement(s.toString());
            }
            return this.getEntryStatement;
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    private PreparedStatement getInsertEntryStatement() {
        try {
            if (this.insertEntryStatement == null) {
                StringBuilder s = new StringBuilder();
                s.append("insert into ");
                s.append(this.tableName);
                s.append(" (");
                s.append(this.columnForValue);
                s.append(", ");
                int i = 0;
                while (i < this.columnsForCoordinates.length) {
                    s.append(this.columnsForCoordinates[i]);
                    if (i < this.columnsForCoordinates.length - 1) {
                        s.append(", ");
                    }
                    ++i;
                }
                s.append(") values (?, ");
                i = 0;
                while (i < this.columnsForCoordinates.length) {
                    s.append("?");
                    if (i < this.columnsForCoordinates.length - 1) {
                        s.append(", ");
                    }
                    ++i;
                }
                s.append(") on duplicate key update ");
                s.append(this.columnForValue);
                s.append("=?");
                this.insertEntryStatement = this.getConnection().prepareStatement(s.toString());
            }
            return this.insertEntryStatement;
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    private PreparedStatement getGetSizeStatement() {
        try {
            if (this.getSizeStatement == null) {
                StringBuilder s = new StringBuilder();
                s.append("select ");
                int i = 0;
                while (i < this.columnsForCoordinates.length) {
                    s.append("max(" + this.columnsForCoordinates[i] + ")");
                    if (i < this.columnsForCoordinates.length - 1) {
                        s.append(", ");
                    }
                    ++i;
                }
                s.append(" from ");
                s.append(this.tableName);
                this.getSizeStatement = this.getConnection().prepareStatement(s.toString());
            }
            return this.getSizeStatement;
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    public synchronized Object getObject(long ... coordinates) {
        try {
            PreparedStatement ps = this.getGetEntryStatement();
            int i = 0;
            while (i < coordinates.length) {
                ps.setLong(i + 1, coordinates[i]);
                ++i;
            }
            ResultSet rs = ps.executeQuery();
            Object o = null;
            if (rs.next()) {
                o = rs.getObject(1);
            }
            rs.close();
            return o;
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    public synchronized void setObject(Object value, long ... coordinates) {
        try {
            PreparedStatement ps = this.getInsertEntryStatement();
            ps.setObject(1, value);
            ps.setObject(coordinates.length + 2, value);
            int i = 0;
            while (i < coordinates.length) {
                ps.setLong(i + 2, coordinates[i]);
                ++i;
            }
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    public synchronized long[] getSize() {
        try {
            if (this.size == null) {
                PreparedStatement ps = this.getGetSizeStatement();
                ResultSet rs = ps.executeQuery();
                rs.next();
                ResultSetMetaData rsMetaData = rs.getMetaData();
                int s = rsMetaData.getColumnCount();
                this.size = new long[s];
                int i = 0;
                while (i < s) {
                    this.size[i] = rs.getLong(i + 1) + 1L;
                    ++i;
                }
                ps.close();
                rs.close();
            }
            return this.size;
        }
        catch (SQLException e) {
            throw new MatrixException(e);
        }
    }

    public synchronized void close() throws IOException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.connection == null || !this.connection.isClosed()) {
            this.connection = DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        return this.connection;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean contains(long ... coordinates) throws MatrixException {
        return this.getObject(coordinates) != null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.connection != null) {
            if (!this.connection.isClosed()) {
                this.connection.close();
            }
            this.connection = null;
        }
    }
}

