/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui;

import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.UJMPFormat;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.gui.AbstractGUIObject;
import org.ujmp.gui.frame.MatrixFrame;
import org.ujmp.gui.panels.MatrixPanel;
import org.ujmp.gui.util.FastListSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixGUIObject
extends AbstractGUIObject
implements TableModel {
    private static final long serialVersionUID = -5777110889052748093L;
    private Matrix matrix = null;
    private int modCount = 0;
    private transient String tooltipText = null;
    private transient ListSelectionModel rowSelectionModel = null;
    private transient ListSelectionModel columnSelectionModel = null;
    private transient EventListenerList listenerList = null;
    private transient JFrame frame = null;
    private transient JPanel panel = null;

    public MatrixGUIObject(Matrix m) {
        this.matrix = m;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public void clear() {
        this.matrix.clear();
        this.fireValueChanged();
    }

    public double getEstimatedMaxValue(long timeOut) throws MatrixException {
        double max = -1.7976931348623157E308;
        long t0 = System.currentTimeMillis();
        double v = 0.0;
        for (long[] c : this.matrix.availableCoordinates()) {
            double d;
            v = this.matrix.getAsDouble(c);
            max = d > max ? v : max;
            long t1 = System.currentTimeMillis();
            if (t1 - t0 <= timeOut) continue;
            return max;
        }
        return max;
    }

    public double getEstimatedMinValue(long timeOut) throws MatrixException {
        double min = Double.MAX_VALUE;
        long t0 = System.currentTimeMillis();
        double v = 0.0;
        for (long[] c : this.matrix.availableCoordinates()) {
            double d;
            v = this.matrix.getAsDouble(c);
            min = d < min ? v : min;
            long t1 = System.currentTimeMillis();
            if (t1 - t0 <= timeOut) continue;
            return min;
        }
        return min;
    }

    public long getValueCount() {
        return this.matrix.getValueCount();
    }

    public final EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    @Override
    public String getLabel() {
        return this.matrix.getLabel();
    }

    @Override
    public void setLabel(String label) {
        this.matrix.setLabel(label);
    }

    @Override
    public final void addTableModelListener(TableModelListener l) {
        this.getListenerList().add(TableModelListener.class, l);
    }

    @Override
    public final void removeTableModelListener(TableModelListener l) {
        this.getListenerList().add(TableModelListener.class, l);
    }

    @Override
    public final String getToolTipText() {
        try {
            if (this.tooltipText == null) {
                StringBuilder s = new StringBuilder();
                s.append("<html>");
                s.append("<table>");
                s.append("<tr>");
                s.append("<td colspan=2><h3>Matrix</h3></td>");
                s.append("</tr>");
                s.append("<tr>");
                s.append("<td><b>Label:</b></td>");
                s.append("<td>" + this.getLabel() + "</td>");
                s.append("</tr>");
                s.append("<tr>");
                s.append("<td><b>Size:</b></td>");
                s.append("<td>" + this.getRowCount() + "x" + this.getColumnCount() + "</td>");
                s.append("</tr>");
                s.append("<tr>");
                s.append("<td><b>Values:</b></td>");
                s.append("<td>");
                s.append("<table border=1>");
                int rowCount = this.getRowCount();
                int columnCount = this.getColumnCount();
                s.append("<tr>");
                s.append("<th></th>");
                int col = 0;
                while (col < columnCount && (long)col < UJMPSettings.getMaxToolTipCols()) {
                    s.append("<th>" + this.matrix.getColumnLabel(col) + "</th>");
                    ++col;
                }
                if ((long)this.getColumnCount() > UJMPSettings.getMaxToolTipCols()) {
                    s.append("<th>...</th>");
                }
                s.append("</tr>");
                int row = 0;
                while (row < rowCount && (long)row < UJMPSettings.getMaxToolTipRows()) {
                    s.append("<tr>");
                    s.append("<th>" + this.matrix.getRowLabel(row) + "</th>");
                    int col2 = 0;
                    while (col2 < columnCount && (long)col2 < UJMPSettings.getMaxToolTipCols()) {
                        s.append("<td align=right>" + UJMPFormat.getSingleLineInstance().format(this.matrix.getAsObject(row, col2)) + "</td>");
                        ++col2;
                    }
                    if ((long)this.getColumnCount() > UJMPSettings.getMaxToolTipCols()) {
                        s.append("<td align=right>...</td>");
                    }
                    s.append("</tr>");
                    ++row;
                }
                if ((long)this.getRowCount() > UJMPSettings.getMaxToolTipRows()) {
                    s.append("<tr>");
                    s.append("<td></td>");
                    col = 0;
                    while (col < this.getColumnCount() && (long)col < UJMPSettings.getMaxToolTipCols()) {
                        s.append("<td align=right>...</td>");
                        ++col;
                    }
                    if ((long)this.getColumnCount() > UJMPSettings.getMaxToolTipCols()) {
                        s.append("<td align=right>...</td>");
                    }
                    s.append("</tr>");
                }
                s.append("</table>");
                s.append("</td>");
                s.append("</tr>");
                s.append("</table>");
                s.append("</html>");
                this.tooltipText = s.toString();
            }
            return this.tooltipText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error getting tooltip text";
        }
    }

    @Override
    public final void fireValueChanged() {
        Object[] objectArray = this.getListenerList().getListenerList();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof TableModelListener) {
                ((TableModelListener)o).tableChanged(new TableModelEvent(this));
            }
            ++n2;
        }
        ++this.modCount;
    }

    public final void fireValueChanged(int row, int column, Object value) {
        Object[] objectArray = this.getListenerList().getListenerList();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof TableModelListener) {
                ((TableModelListener)o).tableChanged(new TableModelEvent(this, row, row, column, 0));
            }
            ++n2;
        }
        ++this.modCount;
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return (int)this.matrix.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String label = this.matrix.getColumnLabel(columnIndex);
        return label == null || "".equals(label) ? "" + columnIndex : label;
    }

    @Override
    public int getRowCount() {
        return (int)this.matrix.getRowCount();
    }

    public Object getValueAt(long[] c) {
        return this.getValueAt((int)c[0], (int)c[1]);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.matrix.getAsObject(rowIndex, columnIndex);
        }
        catch (MatrixException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this.matrix.isReadOnly();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            this.matrix.setAsObject(aValue, rowIndex, columnIndex);
        }
        catch (MatrixException e) {
            e.printStackTrace();
        }
        this.fireValueChanged(rowIndex, columnIndex, aValue);
        this.tooltipText = null;
    }

    public Iterable<long[]> coordinates() {
        return this.matrix.allCoordinates();
    }

    public final String getRowName(int row) {
        String label = this.matrix.getRowLabel(row);
        return label == null || "".equals(label) ? "" + row : label;
    }

    public int getZCount() {
        return (int)this.matrix.getZCount();
    }

    public boolean isSquare() {
        return this.matrix.isSquare();
    }

    public Double getDoubleValueAt(long ... coordinates) throws MatrixException {
        return this.matrix.getAsDouble(coordinates);
    }

    public boolean isSparse() {
        return this.matrix.isSparse();
    }

    public boolean isScalar() {
        return this.matrix.isScalar();
    }

    public ListSelectionModel getColumnSelectionModel() {
        if (this.columnSelectionModel == null) {
            this.columnSelectionModel = new FastListSelectionModel();
        }
        return this.columnSelectionModel;
    }

    public void setColumnSelectionModel(ListSelectionModel columnSelectionModel) {
        this.columnSelectionModel = columnSelectionModel;
    }

    public ListSelectionModel getRowSelectionModel() {
        if (this.rowSelectionModel == null) {
            this.rowSelectionModel = new FastListSelectionModel();
        }
        return this.rowSelectionModel;
    }

    public void setRowSelectionModel(ListSelectionModel rowSelectionModel) {
        this.rowSelectionModel = rowSelectionModel;
    }

    public long[] getSize() {
        return this.matrix.getSize();
    }

    @Override
    public final Icon getIcon() {
        try {
            AbstractTableModel dataModel = new AbstractTableModel(){
                private static final long serialVersionUID = 5562866897873790623L;

                public int getColumnCount() {
                    return 1;
                }

                public int getRowCount() {
                    return 1;
                }

                public Object getValueAt(int row, int col) {
                    return this;
                }
            };
            JTable table = new JTable(dataModel);
            table.getColumnModel().getColumn(0).setWidth(32);
            table.setRowHeight(32);
            int WIDTH = table.getColumnModel().getColumn(0).getWidth() - 1;
            int HEIGHT = table.getRowHeight(0) - 1;
            Class<?> cl = Class.forName("org.ujmp.gui.matrix.MatrixRenderer");
            DefaultTableCellRenderer mr = (DefaultTableCellRenderer)cl.newInstance();
            Component c = mr.getTableCellRendererComponent(table, this, false, false, 0, 0);
            BufferedImage bi = new BufferedImage(WIDTH, HEIGHT, 1);
            c.paint(bi.getGraphics());
            return new ImageIcon(bi);
        }
        catch (Exception e) {
            return new ImageIcon("resources/icons/rebuild.png");
        }
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void setDescription(String description) {
    }

    @Override
    public String toString() {
        if (this.matrix.getLabel() != null) {
            return "[" + Coordinates.toString(this.matrix.getSize()) + "] " + this.matrix.getClass().getSimpleName() + " [" + this.matrix.getLabel() + "]";
        }
        return "[" + Coordinates.toString(this.matrix.getSize()) + "] " + this.matrix.getClass().getSimpleName();
    }

    @Override
    public Matrix getCoreObject() {
        return this.matrix;
    }

    @Override
    public JFrame getFrame() {
        if (this.frame == null) {
            this.frame = new MatrixFrame(this);
        }
        return this.frame;
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new MatrixPanel(this);
        }
        return this.panel;
    }
}

