/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui;

import javax.swing.JFrame;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.util.FrameManager;
import org.ujmp.gui.util.UIDefaults;

public abstract class AbstractGUIObject
implements GUIObject {
    private static final long serialVersionUID = -2271465024665498798L;
    public static final int X = 1;
    public static final int Y = 0;
    public static final int Z = 2;
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    public static final int ALL = Integer.MAX_VALUE;
    private int modCount = 0;

    static {
        UIDefaults.setDefaults();
    }

    public AbstractGUIObject() {
    }

    public AbstractGUIObject(String label) {
        this();
        this.setLabel(label);
    }

    public AbstractGUIObject(String label, String description) {
        this(label);
        this.setDescription(description);
    }

    public abstract String toString();

    public void fireValueChanged() {
        ++this.modCount;
    }

    public final JFrame showGUI() {
        return FrameManager.showFrame(this);
    }

    public String getToolTipText() {
        StringBuilder s = new StringBuilder();
        s.append("<html>");
        s.append("<table>");
        s.append("<tr>");
        s.append("<td colspan=2><h3>" + this.getClass().getSimpleName() + "</h3></td>");
        s.append("</tr>");
        s.append("<tr>");
        s.append("<td><b>Label:</b></td>");
        s.append("<td>" + this.getLabel() + "</td>");
        s.append("</tr>");
        s.append("<td><b>Description:</b></td>");
        s.append("<td>" + this.getDescription() + "</td>");
        s.append("</tr>");
        s.append("</table>");
        s.append("</html>");
        return s.toString();
    }

    public int getModCount() {
        return this.modCount;
    }
}

