/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.ejml.calculation;

import org.ejml.alg.dense.decomposition.DecompositionFactory;
import org.ejml.alg.dense.decomposition.QRDecomposition;
import org.ejml.alg.dense.linsol.qr.LinearSolverQrHouseCol;
import org.ejml.data.DenseMatrix64F;
import org.ujmp.core.Matrix;
import org.ujmp.ejml.EJMLDenseDoubleMatrix2D;

public class QR
implements org.ujmp.core.doublematrix.calculation.general.decomposition.QR<Matrix> {
    public static QR INSTANCE = new QR();

    public Matrix[] calc(Matrix source) {
        try {
            QRDecomposition qr = DecompositionFactory.qr();
            DenseMatrix64F matrix = null;
            matrix = source instanceof EJMLDenseDoubleMatrix2D ? ((EJMLDenseDoubleMatrix2D)source).getWrappedObject() : new EJMLDenseDoubleMatrix2D(source).getWrappedObject();
            qr.decompose(matrix);
            DenseMatrix64F qm = new DenseMatrix64F(matrix.numRows, matrix.numRows);
            DenseMatrix64F rm = new DenseMatrix64F(matrix.numRows, matrix.numCols);
            qr.getQ(qm, true);
            qr.getR(rm, false);
            EJMLDenseDoubleMatrix2D q = new EJMLDenseDoubleMatrix2D(qm);
            EJMLDenseDoubleMatrix2D r = new EJMLDenseDoubleMatrix2D(rm);
            return new Matrix[]{q, r};
        }
        catch (Throwable t) {
            return org.ujmp.core.doublematrix.calculation.general.decomposition.QR.UJMP.calc(source);
        }
    }

    @Override
    public Matrix solve(Matrix a, Matrix b) {
        try {
            LinearSolverQrHouseCol solver = new LinearSolverQrHouseCol();
            DenseMatrix64F a2 = null;
            DenseMatrix64F b2 = null;
            a2 = a instanceof EJMLDenseDoubleMatrix2D ? ((EJMLDenseDoubleMatrix2D)a).getWrappedObject() : new EJMLDenseDoubleMatrix2D(a).getWrappedObject();
            b2 = b instanceof EJMLDenseDoubleMatrix2D ? ((EJMLDenseDoubleMatrix2D)b).getWrappedObject() : new EJMLDenseDoubleMatrix2D(b).getWrappedObject();
            solver.setA(a2);
            DenseMatrix64F x = new DenseMatrix64F(a2.numCols, b2.numCols);
            solver.solve(b2, x);
            return new EJMLDenseDoubleMatrix2D(x);
        }
        catch (Throwable t) {
            return org.ujmp.core.doublematrix.calculation.general.decomposition.QR.UJMP.solve(a, b);
        }
    }
}

