/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.FileFormat;

public class Matlab {
    public static String[] SEARCH = new String[0];
    public static final String MATLABPARAMETERS = "-nosplash -nojvm";
    private static String pathToMatlab;
    private BufferedReader input = null;
    private BufferedWriter output = null;
    private BufferedReader error = null;
    private Process matlabProcess = null;
    private boolean running = false;
    private static Matlab matlab;

    static {
        try {
            SEARCH = new String[]{System.getProperty("Matlab"), String.valueOf(System.getProperty("user.home")) + "/matlab/bin/matlab", "/usr/bin/matlab", "/opt/matlab/bin/matlab"};
        }
        catch (Exception exception) {
            // empty catch block
        }
        pathToMatlab = null;
        matlab = null;
    }

    public static synchronized Matlab getInstance() throws Exception {
        if (matlab == null) {
            matlab = Matlab.getInstance(Matlab.findMatlab());
        }
        return matlab;
    }

    private static String findMatlab() {
        if (pathToMatlab == null) {
            File file = null;
            String[] stringArray = SEARCH;
            int n = SEARCH.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && (file = new File(s)).exists()) {
                    pathToMatlab = file.getAbsolutePath();
                    return pathToMatlab;
                }
                ++n2;
            }
        }
        return pathToMatlab;
    }

    public static synchronized Matlab getInstance(String pathToMatlab) throws Exception {
        if (matlab == null) {
            matlab = new Matlab(pathToMatlab);
        }
        return matlab;
    }

    private Matlab(String pathToMatlab) throws Exception {
        this.matlabProcess = Runtime.getRuntime().exec(String.valueOf(pathToMatlab) + " " + MATLABPARAMETERS);
        this.output = new BufferedWriter(new OutputStreamWriter(this.matlabProcess.getOutputStream()));
        this.input = new BufferedReader(new InputStreamReader(this.matlabProcess.getInputStream()));
        this.error = new BufferedReader(new InputStreamReader(this.matlabProcess.getErrorStream()));
        String startMessage = this.getFromMatlab();
        if (startMessage != null && startMessage.length() > 0) {
            this.running = true;
            return;
        }
        throw new Exception("could not start Matlab");
    }

    /*
     * Unable to fully structure code
     */
    private synchronized String getFromMatlab() throws Exception {
        endSeen = false;
        sb = new StringBuilder();
        block0: while (true) {
            if (!this.input.ready()) {
                Thread.yield();
                continue;
            }
            while (true) {
                if (this.input.ready()) ** break;
                continue block0;
                c = (char)this.input.read();
                sb.append(c);
                if (c == '>') {
                    if (endSeen) {
                        return sb.substring(0, sb.length() - 2);
                    }
                    endSeen = true;
                    continue;
                }
                endSeen = false;
            }
            break;
        }
    }

    public String execute(String command) throws Exception {
        this.sendToMatlab(command);
        return this.getFromMatlab();
    }

    public synchronized void shutdown() throws Exception {
        this.sendToMatlab("exit");
        this.matlabProcess.waitFor();
        this.output.close();
        this.input.close();
    }

    private synchronized void sendToMatlab(String command) throws Exception {
        if (!command.endsWith("\n")) {
            command = String.valueOf(command) + "\n";
        }
        this.output.write(command, 0, command.length());
        this.output.flush();
    }

    public void setMatrix(String label, Matrix matrix) throws Exception {
        this.execute(String.valueOf(label) + "=" + matrix.exportToString(FileFormat.M, new Object[0]));
    }

    public Matrix getMatrix(String label) throws Exception {
        try {
            String rawRows = this.execute("fprintf(1,'%d\\n',size(" + label + ",1));");
            int rows = Integer.parseInt(rawRows.trim());
            String rawCols = this.execute("fprintf(1,'%d\\n',size(" + label + ",2));");
            int cols = Integer.parseInt(rawCols.trim());
            String rawText = this.execute("fprintf(1,'%55.55f\\n'," + label + ")");
            String[] rawValues = rawText.split("\n");
            Matrix matrix = MatrixFactory.zeros(rows, cols);
            int i = 0;
            int c = 0;
            while (c < cols) {
                int r = 0;
                while (r < rows) {
                    matrix.setAsDouble(Double.parseDouble(rawValues[i++]), r, c);
                    ++r;
                }
                ++c;
            }
            return matrix;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAvailable() {
        return Matlab.findMatlab() != null;
    }

    public void plot(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("plot(ujmpmatrix" + Matlab.toString(format) + ");");
    }

    public void hist(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("hist(ujmpmatrix" + Matlab.toString(format) + ");");
    }

    public void surf(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("surf(ujmpmatrix" + Matlab.toString(format) + ");");
    }

    public void imagesc(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("imagesc(ujmpmatrix" + Matlab.toString(format) + ");");
    }

    public void bar(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("bar(ujmpmatrix" + Matlab.toString(format) + ");");
    }

    public void errorbar(Matrix x, Matrix y, Matrix e, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.setMatrix("ujmpmatrix_e", e);
        this.execute("figure;");
        this.execute("errorbar(ujmpmatrix_x,ujmpmatrix_y,ujmpmatrix_e" + Matlab.toString(format) + ");");
    }

    public void barh(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("barh(ujmpmatrix" + Matlab.toString(format) + ");");
    }

    public void stem(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("stem(ujmpmatrix" + Matlab.toString(format) + ");");
    }

    public void pie(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("pie(ujmpmatrix" + Matlab.toString(format) + ");");
    }

    public void pie3(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("pie3(ujmpmatrix" + Matlab.toString(format) + ");");
    }

    public void plotmatrix(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("plotmatrix(ujmpmatrix" + Matlab.toString(format) + ");");
    }

    public void plot(Matrix x, Matrix y, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.execute("figure;");
        this.execute("plot(ujmpmatrix_x,ujmpmatrix_y" + Matlab.toString(format) + ");");
    }

    public static String toString(String[] strings) {
        if (strings.length != 0) {
            return ",'" + strings[0] + "'";
        }
        return "";
    }
}

