/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.calculation;

import java.util.HashSet;
import java.util.Set;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.stringmatrix.calculation.AbstractStringCalculation;
import org.ujmp.core.util.StringUtil;

public class RemovePunctuation
extends AbstractStringCalculation {
    private static final long serialVersionUID = 4734721685667215634L;
    public static Set<Character> allowedChars = null;

    static {
        allowedChars = new HashSet<Character>();
        allowedChars.add(Character.valueOf(' '));
        char c = 'a';
        while (c <= 'z') {
            allowedChars.add(Character.valueOf(c));
            c = (char)(c + '\u0001');
        }
        c = 'A';
        while (c <= 'Z') {
            allowedChars.add(Character.valueOf(c));
            c = (char)(c + '\u0001');
        }
    }

    public RemovePunctuation(Matrix m) {
        super(m);
    }

    public String getString(long ... coordinates) throws MatrixException {
        String s = this.getSource().getAsString(coordinates);
        s = StringUtil.retainChars(s, allowedChars, ' ');
        s = s.replaceAll("\\s+", " ");
        return s;
    }
}

