/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.stub;

import java.util.Map;
import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.CoordinateSetToLongWrapper;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapToSparseMatrixWrapper
extends AbstractSparseObjectMatrix
implements Wrapper<Map<Coordinates, Object>> {
    private static final long serialVersionUID = -6292034262789053069L;
    private final Object defaultValue = null;
    private int maximumNumberOfEntries = -1;
    private long[] size = null;

    public AbstractMapToSparseMatrixWrapper(Matrix m) {
        this.size = Coordinates.copyOf(m.getSize());
        for (long[] c : m.allCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
    }

    public AbstractMapToSparseMatrixWrapper(Matrix m, int maximumNumberOfEntries) {
        this.size = Coordinates.copyOf(m.getSize());
        this.setMaximumNumberOfEntries(maximumNumberOfEntries);
        for (long[] c : m.allCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
    }

    public AbstractMapToSparseMatrixWrapper(long ... size) {
        this.size = Coordinates.copyOf(size);
    }

    public abstract Map<Coordinates, Object> getMap();

    public abstract void setMap(Map<Coordinates, Object> var1);

    @Override
    public final long[] getSize() {
        return this.size;
    }

    @Override
    public final Map<Coordinates, Object> getWrappedObject() {
        return this.getMap();
    }

    @Override
    public final void setWrappedObject(Map<Coordinates, Object> object) {
        this.setMap(object);
    }

    @Override
    public final Object getObject(long ... coordinates) throws MatrixException {
        Object v = this.getMap().get(new Coordinates(coordinates));
        return v == null ? this.defaultValue : v;
    }

    @Override
    public final boolean contains(long ... coordinates) {
        return this.getMap().containsKey(new Coordinates(coordinates));
    }

    @Override
    public final double getAsDouble(long ... coordinates) throws MatrixException {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public final void setAsDouble(double v, long ... coordinates) throws MatrixException {
        this.setObject((Object)v, coordinates);
    }

    @Override
    public final void setObject(Object o, long ... coordinates) throws MatrixException {
        while (this.maximumNumberOfEntries > 0 && this.getMap().size() > this.maximumNumberOfEntries) {
            this.getMap().remove(this.getMap().keySet().iterator().next());
        }
        if (Coordinates.isSmallerThan(coordinates, this.getSize())) {
            this.getMap().put(new Coordinates(coordinates), o);
        }
    }

    public final int getMaximumNumberOfEntries() {
        return this.maximumNumberOfEntries;
    }

    @Override
    public final long getValueCount() {
        return this.getMap().size();
    }

    @Override
    public final Iterable<long[]> availableCoordinates() {
        return new CoordinateSetToLongWrapper(this.getMap().keySet());
    }

    public final void setMaximumNumberOfEntries(int maximumNumberOfEntries) {
        this.maximumNumberOfEntries = maximumNumberOfEntries;
    }
}

