/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.Iterator;
import org.ujmp.core.Matrix;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.annotation.DefaultAnnotation;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transpose
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -2749226948849267413L;
    private int swap1 = 0;
    private int swap2 = 1;

    public Transpose(Matrix m) {
        this(m, 0, 1);
    }

    public Transpose(Matrix m, int swap1, int swap2) {
        super(m);
        this.swap1 = swap1;
        this.swap2 = swap2;
        Annotation aold = m.getAnnotation();
        if (aold != null) {
            DefaultAnnotation a = new DefaultAnnotation(this.getSize());
            a.setMatrixAnnotation(aold.getMatrixAnnotation());
            int i = 0;
            while (i < m.getDimensionCount()) {
                Matrix am = aold.getDimensionMatrix(i);
                am = am.transpose(Calculation.Ret.NEW, swap1, swap2);
                if (i == swap1) {
                    a.setDimensionMatrix(swap2, am);
                } else if (i == swap2) {
                    a.setDimensionMatrix(swap1, am);
                } else {
                    a.setDimensionMatrix(i, am);
                }
                ++i;
            }
            this.setAnnotation(a);
        }
    }

    @Override
    public Object getObject(long ... coordinates) throws MatrixException {
        return this.getSource().getAsObject(Coordinates.transpose(coordinates, this.swap1, this.swap2));
    }

    @Override
    public long[] getSize() {
        return Coordinates.transpose(this.getSource().getSize(), this.swap1, this.swap2);
    }

    @Override
    public boolean contains(long ... coordinates) {
        return this.getSource().contains(Coordinates.transpose(coordinates, this.swap1, this.swap2));
    }

    @Override
    public boolean isSparse() {
        return this.getSource().isSparse();
    }

    @Override
    public long getValueCount() {
        return this.getSource().getValueCount();
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new Iterable<long[]>(){

            @Override
            public Iterator<long[]> iterator() {
                return new TransposedIterator();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransposedIterator
    implements Iterator<long[]> {
        private final Iterator<long[]> iterator;

        TransposedIterator() {
            this.iterator = Transpose.this.getSource().availableCoordinates().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public long[] next() {
            return Coordinates.transpose(this.iterator.next(), Transpose.this.swap1, Transpose.this.swap2);
        }

        @Override
        public void remove() {
        }
    }
}

