/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.ObjectMatrix;
import org.ujmp.core.objectmatrix.calculation.ObjectCalculation;
import org.ujmp.core.objectmatrix.impl.ObjectCalculationMatrix;

public abstract class AbstractObjectCalculation
extends AbstractCalculation
implements ObjectCalculation {
    private static final long serialVersionUID = 7767220107834181824L;

    public AbstractObjectCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractObjectCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final ObjectMatrix calcLink() throws MatrixException {
        return new ObjectCalculationMatrix(this);
    }

    public final Matrix calcNew() throws MatrixException {
        Matrix result = MatrixFactory.zeros(this.getValueType(), this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsObject(this.getObject(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsObject(this.getObject(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setObject(Object value, long ... coordinates) throws MatrixException {
    }

    public ValueType getValueType() {
        return this.getSource().getValueType();
    }
}

