/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.io.IntelligentFileReader;

public abstract class ImportMatrixSTRING {
    public static final Matrix fromString(String string, Object ... parameters) throws MatrixException {
        StringReader sr = new StringReader(string);
        IntelligentFileReader r = new IntelligentFileReader(sr);
        Matrix m = ImportMatrixSTRING.fromReader(r, new Object[0]);
        r.close();
        return m;
    }

    public static final Matrix fromStream(InputStream stream, Object ... parameters) throws MatrixException, IOException {
        InputStreamReader r = new InputStreamReader(stream, "UTF-8");
        Matrix m = ImportMatrixSTRING.fromReader(r, parameters);
        r.close();
        return m;
    }

    public static final Matrix fromFile(File file, Object ... parameters) throws MatrixException, IOException {
        FileInputStream lr = new FileInputStream(file);
        Matrix m = ImportMatrixSTRING.fromStream(lr, parameters);
        m.setLabel(file.getAbsolutePath());
        lr.close();
        return m;
    }

    public static final Matrix fromReader(Reader reader, Object ... parameters) throws MatrixException {
        StringBuilder s = new StringBuilder();
        try {
            IntelligentFileReader lr = new IntelligentFileReader(reader);
            String line = null;
            while ((line = lr.readLine()) != null) {
                if (line.length() <= 0) continue;
                s.append(String.valueOf(line) + "\n");
            }
            lr.close();
            Matrix m = MatrixFactory.zeros(ValueType.STRING, 1L, 1L);
            m.setAsString(s.toString(), 0L, 0L);
            return m;
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }
}

