/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.graphmatrix;

import java.util.ArrayList;
import java.util.List;
import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.genericmatrix.stub.AbstractSparseGenericMatrix2D;
import org.ujmp.core.graphmatrix.GraphMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphMatrix<N, E>
extends AbstractSparseGenericMatrix2D<E>
implements GraphMatrix<N, E> {
    private static final long serialVersionUID = -4939918585100574441L;

    @Override
    public boolean contains(long ... coordinates) {
        return this.getEdgeList().contains(new Coordinates(coordinates));
    }

    @Override
    public void removeUndirectedEdge(N node1, N node2) {
        long index1 = this.getIndexOfNode(node1);
        long index2 = this.getIndexOfNode(node2);
        this.removeDirectedEdge((N)index1, (N)index2);
        this.removeDirectedEdge((N)index2, (N)index1);
    }

    @Override
    public boolean isConnected(N node1, N node2) {
        long index1 = this.getIndexOfNode(node1);
        long index2 = this.getIndexOfNode(node2);
        return this.isConnected(index1, index2);
    }

    @Override
    public List<N> getParents(long index) {
        List<Long> indices = this.getParentIndices((N)index);
        ArrayList objects = new ArrayList(indices.size());
        int i = 0;
        while (i < indices.size()) {
            objects.add(this.getNode(indices.get(i)));
            ++i;
        }
        return objects;
    }

    @Override
    public List<N> getParents(N node) {
        List<Long> indices = this.getParentIndices(node);
        ArrayList objects = new ArrayList(indices.size());
        int i = 0;
        while (i < indices.size()) {
            objects.add(this.getNode(indices.get(i)));
            ++i;
        }
        return objects;
    }

    @Override
    public List<N> getChildren(long index) {
        List<Long> indices = this.getChildIndices((N)index);
        ArrayList objects = new ArrayList(indices.size());
        int i = 0;
        while (i < indices.size()) {
            objects.add(this.getNode(indices.get(i)));
            ++i;
        }
        return objects;
    }

    @Override
    public List<Long> getParentIndices(N node) {
        long index = this.getIndexOfNode(node);
        return this.getParentIndices((N)index);
    }

    @Override
    public E getEdgeValue(N node1, N node2) {
        long index1 = this.getIndexOfNode(node1);
        long index2 = this.getIndexOfNode(node2);
        return this.getEdgeValue((N)index1, (N)index2);
    }

    @Override
    public int getDegree(N node) {
        return this.getParentCount(node) + this.getChildCount(node);
    }

    @Override
    public int getDegree(long nodeIndex) {
        return this.getParentCount((N)nodeIndex) + this.getChildCount((N)nodeIndex);
    }

    @Override
    public void addChild(long nodeIndex, long childIndex) {
        this.addEdge(nodeIndex, childIndex);
    }

    @Override
    public void addParent(long nodeIndex, long parentIndex) {
        this.addEdge(nodeIndex, parentIndex);
    }

    @Override
    public int getChildCount(N node) {
        return this.getChildCount((N)this.getIndexOfNode(node));
    }

    @Override
    public void addParent(N node, N parent) {
        long parentIndex = this.getIndexOfNode(node);
        long nodeIndex = this.getIndexOfNode(node);
        this.addParent(nodeIndex, parentIndex);
    }

    @Override
    public int getParentCount(N node) {
        long index = this.getIndexOfNode(node);
        return this.getParentCount((N)index);
    }

    @Override
    public List<Long> getChildIndices(N node) {
        long index = this.getIndexOfNode(node);
        return this.getChildIndices((N)index);
    }

    @Override
    public List<N> getChildren(N node) {
        List<Long> indices = this.getChildIndices(node);
        ArrayList objects = new ArrayList(indices.size());
        int i = 0;
        while (i < indices.size()) {
            objects.add(this.getNode(indices.get(i)));
            ++i;
        }
        return objects;
    }

    @Override
    public void removeUndirectedEdge(long nodeIndex1, long nodeIndex2) {
        this.removeDirectedEdge((N)nodeIndex1, (N)nodeIndex2);
        this.removeDirectedEdge((N)nodeIndex2, (N)nodeIndex1);
    }

    @Override
    public void removeDirectedEdge(N node1, N node2) {
        long index1 = this.getIndexOfNode(node1);
        long index2 = this.getIndexOfNode(node2);
        this.removeDirectedEdge((N)index1, (N)index2);
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return super.availableCoordinates();
    }

    @Override
    public long[] getSize() {
        return new long[]{this.getNodeList().size(), this.getNodeList().size()};
    }

    @Override
    public E getObject(long row, long column) {
        return this.getEdgeValue((N)row, (N)column);
    }

    @Override
    public E getObject(int row, int column) {
        return this.getEdgeValue((N)row, (N)column);
    }

    @Override
    public long getValueCount() {
        return this.getEdgeList().size();
    }

    @Override
    public final void addDirectedEdge(N node1, N node2) {
        long i1 = this.getIndexOfNode(node1);
        long i2 = this.getIndexOfNode(node2);
        this.addDirectedEdge(i1, i2);
    }

    @Override
    public abstract void addUndirectedEdge(long var1, long var3);

    @Override
    public abstract void addDirectedEdge(long var1, long var3);

    @Override
    public final void addUndirectedEdge(N node1, N node2) {
        long i1 = this.getIndexOfNode(node1);
        long i2 = this.getIndexOfNode(node2);
        this.addUndirectedEdge(i1, i2);
    }

    @Override
    public final boolean isConnected(long node1, long node2) {
        return this.getObject(node1, node2) != null;
    }

    @Override
    public final long getIndexOfNode(N o) {
        return this.getNodeList().indexOf(o);
    }

    @Override
    public void setUndirectedEdge(E value, long node1, long node2) {
        this.setDirectedEdge(value, (N)node1, (N)node2);
        this.setDirectedEdge(value, (N)node2, (N)node1);
    }

    @Override
    public void setDirectedEdge(E edgeObject, N node1, N node2) {
        long index1 = this.getIndexOfNode(node1);
        long index2 = this.getIndexOfNode(node2);
        this.setDirectedEdge(edgeObject, (N)index1, (N)index2);
    }

    @Override
    public void setUndirectedEdge(E edgeObject, N node1, N node2) {
        long index1 = this.getIndexOfNode(node1);
        long index2 = this.getIndexOfNode(node2);
        this.setUndirectedEdge(edgeObject, (N)index1, (N)index2);
    }

    @Override
    public abstract void clear();

    @Override
    public final Matrix.StorageType getStorageType() {
        return Matrix.StorageType.GRAPH;
    }
}

