/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.annotation.DefaultAnnotation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;

public class Prod
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 932987805882530211L;
    boolean ignoreNaN = false;

    public Prod(int dimension, boolean ignoreNaN, Matrix matrix) {
        super(dimension, matrix);
        this.ignoreNaN = ignoreNaN;
        Annotation aold = matrix.getAnnotation();
        if (aold != null) {
            DefaultAnnotation a = new DefaultAnnotation(this.getSize());
            a.setMatrixAnnotation(aold.getMatrixAnnotation());
            if (dimension == 0) {
                a.setDimensionMatrix(0, aold.getDimensionMatrix(0));
            } else if (dimension == 1) {
                a.setDimensionMatrix(1, aold.getDimensionMatrix(1));
            }
            this.setAnnotation(a);
        }
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        double prod = 1.0;
        if (this.ignoreNaN) {
            switch (this.getDimension()) {
                case 0: {
                    long r = this.getSource().getSize()[0] - 1L;
                    while (r != -1L) {
                        double v = this.getSource().getAsDouble(r, coordinates[1]);
                        if (!MathUtil.isNaNOrInfinite(v)) {
                            prod *= v;
                        }
                        --r;
                    }
                    return prod;
                }
                case 1: {
                    long c = this.getSource().getSize()[1] - 1L;
                    while (c != -1L) {
                        double v = this.getSource().getAsDouble(coordinates[0], c);
                        if (!MathUtil.isNaNOrInfinite(v)) {
                            prod *= v;
                        }
                        --c;
                    }
                    return prod;
                }
                case 0x7FFFFFFF: {
                    long r = this.getSource().getSize()[0] - 1L;
                    while (r != -1L) {
                        long c = this.getSource().getSize()[1] - 1L;
                        while (c != -1L) {
                            double v = this.getSource().getAsDouble(r, c);
                            if (!MathUtil.isNaNOrInfinite(v)) {
                                prod *= v;
                            }
                            --c;
                        }
                        --r;
                    }
                    return prod;
                }
            }
            throw new MatrixException("dimension not allowed");
        }
        switch (this.getDimension()) {
            case 0: {
                long r = this.getSource().getSize()[0] - 1L;
                while (r != -1L) {
                    prod *= this.getSource().getAsDouble(r--, coordinates[1]);
                }
                return prod;
            }
            case 1: {
                long c = this.getSource().getSize()[1] - 1L;
                while (c != -1L) {
                    prod *= this.getSource().getAsDouble(coordinates[0], c--);
                }
                return prod;
            }
            case 0x7FFFFFFF: {
                long r = this.getSource().getSize()[0] - 1L;
                while (r != -1L) {
                    long c = this.getSource().getSize()[1] - 1L;
                    while (c != -1L) {
                        prod *= this.getSource().getAsDouble(r, c--);
                    }
                    --r;
                }
                return prod;
            }
        }
        throw new MatrixException("dimension not allowed");
    }

    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
            case 0x7FFFFFFF: {
                return new long[]{1L, 1L};
            }
        }
        return null;
    }
}

