/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.annotation.DefaultAnnotation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;

public class Min
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 2209647170194250477L;

    public Min(int dimension, Matrix matrix) {
        super(dimension, matrix);
        Annotation aold = matrix.getAnnotation();
        if (aold != null) {
            DefaultAnnotation a = new DefaultAnnotation(this.getSize());
            a.setMatrixAnnotation(aold.getMatrixAnnotation());
            if (dimension == 0) {
                a.setDimensionMatrix(0, aold.getDimensionMatrix(0));
            } else if (dimension == 1) {
                a.setDimensionMatrix(1, aold.getDimensionMatrix(1));
            }
            this.setAnnotation(a);
        }
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        double min = Double.MAX_VALUE;
        switch (this.getDimension()) {
            case 0: {
                long r = this.getSource().getSize()[0] - 1L;
                while (r != -1L) {
                    long[] lArray = new long[]{r, coordinates[1]};
                    double v = this.getSource().getAsDouble(lArray);
                    if (v < min) {
                        min = v;
                    }
                    --r;
                }
                min = min == Double.MAX_VALUE ? Double.NaN : min;
                return min;
            }
            case 1: {
                long c = this.getSource().getSize()[1] - 1L;
                while (c != -1L) {
                    long[] lArray = new long[]{coordinates[0], c};
                    double v = this.getSource().getAsDouble(lArray);
                    if (v < min) {
                        min = v;
                    }
                    --c;
                }
                min = min == Double.MAX_VALUE ? Double.NaN : min;
                return min;
            }
            case 0x7FFFFFFF: {
                long r = this.getSource().getSize()[0] - 1L;
                while (r != -1L) {
                    long c = this.getSource().getSize()[1] - 1L;
                    while (c != -1L) {
                        long[] lArray = new long[]{r, c};
                        double v = this.getSource().getAsDouble(lArray);
                        if (v < min) {
                            min = v;
                        }
                        --c;
                    }
                    --r;
                }
                min = min == Double.MAX_VALUE ? Double.NaN : min;
                return min;
            }
        }
        return 0.0;
    }

    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
            case 0x7FFFFFFF: {
                return new long[]{1L, 1L};
            }
        }
        throw new MatrixException("dimension not supported: " + this.getDimension());
    }

    public static double calc(Matrix m) throws MatrixException {
        double min = Double.MAX_VALUE;
        double v = 0.0;
        for (long[] c : m.availableCoordinates()) {
            double d;
            v = m.getAsDouble(c);
            double d2 = min = d < min ? v : min;
        }
        min = min == Double.MAX_VALUE ? Double.NaN : min;
        return min;
    }
}

