/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.missingvalues;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.Impute;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;

public class ImputeRegression
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 2147234720707721364L;
    Matrix firstGuess = null;
    Matrix imputed = null;

    public ImputeRegression(Matrix matrix) {
        super(matrix);
    }

    public ImputeRegression(Matrix matrix, Matrix firstGuess) {
        super(matrix);
        this.firstGuess = firstGuess;
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        double v;
        if (this.imputed == null) {
            this.createMatrix();
        }
        if (MathUtil.isNaNOrInfinite(v = this.getSource().getAsDouble(coordinates))) {
            return this.imputed.getAsDouble(coordinates);
        }
        return v;
    }

    private void createMatrix() {
        try {
            Matrix x = this.getSource();
            if (this.firstGuess == null) {
                this.firstGuess = this.getSource().impute(Calculation.Ret.NEW, Impute.ImputationMethod.RowMean, new Object[0]);
            }
            this.imputed = MatrixFactory.zeros(x.getSize());
            ExecutorService executor = Executors.newFixedThreadPool(1);
            ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
            long t0 = System.currentTimeMillis();
            long l = 0L;
            while (l < x.getColumnCount()) {
                futures.add(executor.submit(new PredictColumn(l)));
                ++l;
            }
            for (Future future : futures) {
                Long completedCols = (Long)future.get();
                long elapsedTime = System.currentTimeMillis() - t0;
                long remainingCols = x.getColumnCount() - completedCols;
                double colsPerMillisecond = (double)(completedCols + 1L) / (double)elapsedTime;
                long remainingTime = (long)((double)remainingCols / colsPerMillisecond / 1000.0);
                System.out.println(String.valueOf((double)(completedCols * 1000L / x.getColumnCount()) / 10.0) + "% completed (" + remainingTime + " seconds remaining)");
            }
            executor.shutdown();
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    private static Matrix replaceInColumn(Matrix original, Matrix firstGuess, long column) throws MatrixException {
        Matrix x = firstGuess.deleteColumns(Calculation.Ret.NEW, column);
        Matrix y = original.selectColumns(Calculation.Ret.NEW, column);
        ArrayList<Long> missingRows = new ArrayList<Long>();
        long i = y.getRowCount();
        while (--i >= 0L) {
            double v = y.getAsDouble(i, 0L);
            if (!MathUtil.isNaNOrInfinite(v)) continue;
            missingRows.add(i);
        }
        if (missingRows.isEmpty()) {
            return y;
        }
        Matrix xdel = x.deleteRows(Calculation.Ret.NEW, missingRows);
        Matrix bias1 = MatrixFactory.ones(xdel.getRowCount(), 1L);
        Matrix xtrain = MatrixFactory.horCat(xdel, bias1);
        Matrix ytrain = y.deleteRows(Calculation.Ret.NEW, missingRows);
        Matrix xinv = xtrain.pinv();
        Matrix b = xinv.mtimes(ytrain);
        Matrix bias2 = MatrixFactory.ones(x.getRowCount(), 1L);
        Matrix yPredicted = MatrixFactory.horCat(x, bias2).mtimes(b);
        int row = 0;
        while ((long)row < y.getRowCount()) {
            double v = y.getAsDouble(row, 0L);
            if (!Double.isNaN(v)) {
                yPredicted.setAsDouble(v, row, 0L);
            }
            ++row;
        }
        return yPredicted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PredictColumn
    implements Callable<Long> {
        long column = 0L;

        public PredictColumn(long column) {
            this.column = column;
        }

        @Override
        public Long call() throws Exception {
            Matrix newColumn = ImputeRegression.replaceInColumn(ImputeRegression.this.getSource(), ImputeRegression.this.firstGuess, this.column);
            int r = 0;
            while ((long)r < newColumn.getRowCount()) {
                ImputeRegression.this.imputed.setAsDouble(newColumn.getAsDouble(r, 0L), r, this.column);
                ++r;
            }
            return this.column;
        }
    }
}

