/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.calculation.general.decomposition.LU;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Inv<T> {
    public static final int THRESHOLD = 100;
    public static final Inv<Matrix> MATRIX = new Inv<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            if (source.getDimensionCount() != 2 || source.getRowCount() != source.getColumnCount()) {
                throw new MatrixException("inverse only possible for square matrices. use pinv or ginv instead");
            }
            if (UJMPSettings.getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.calc(source);
                }
                return MATRIXSMALLSINGLETHREADED.calc(source);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.calc(source);
            }
            return MATRIXSMALLMULTITHREADED.calc(source);
        }
    };
    public static final Inv<Matrix> UJMP = new Inv<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            DenseDoubleMatrix2D b = DenseDoubleMatrix2D.factory.dense(source.getRowCount(), source.getRowCount());
            int i = (int)source.getRowCount();
            while (--i >= 0) {
                b.setDouble(1.0, i, i);
            }
            return LU.INSTANCE.solve(source, b);
        }
    };
    public static final Inv<Matrix> INSTANCE = MATRIX;
    public static final Inv<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;
    public static final Inv<Matrix> MATRIXLARGESINGLETHREADED = new Inv<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            Inv inv = DecompositionOps.INV_OJALGO;
            if (inv == null) {
                inv = DecompositionOps.INV_EJML;
            }
            if (inv == null) {
                inv = DecompositionOps.INV_MTJ;
            }
            if (inv == null) {
                inv = DecompositionOps.INV_OJALGO;
            }
            if (inv == null) {
                inv = UJMP;
            }
            return inv.calc(source);
        }
    };
    public static final Inv<Matrix> MATRIXLARGEMULTITHREADED = new Inv<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            Inv inv = DecompositionOps.INV_OJALGO;
            if (inv == null) {
                inv = DecompositionOps.INV_OJALGO;
            }
            if (inv == null) {
                inv = DecompositionOps.INV_EJML;
            }
            if (inv == null) {
                inv = DecompositionOps.INV_MTJ;
            }
            if (inv == null) {
                inv = UJMP;
            }
            return inv.calc(source);
        }
    };
    public static final Inv<Matrix> MATRIXSMALLMULTITHREADED = UJMP;

    public T calc(T var1);
}

