/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.datematrix.impl;

import java.util.Date;
import org.ujmp.core.Matrix;
import org.ujmp.core.datematrix.stub.AbstractDenseDateMatrix2D;
import org.ujmp.core.exceptions.MatrixException;

public class SimpleDenseDateMatrix2D
extends AbstractDenseDateMatrix2D {
    private static final long serialVersionUID = -3791410138052404116L;
    private Date[][] values = null;

    public SimpleDenseDateMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof SimpleDenseDateMatrix2D) {
            Date[][] v = ((SimpleDenseDateMatrix2D)m).values;
            this.values = new Date[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new Date[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsDate(m.getAsDate(c), c);
            }
        }
    }

    public SimpleDenseDateMatrix2D(Date[] ... v) {
        this.values = v;
    }

    public SimpleDenseDateMatrix2D(long ... size) {
        this.values = new Date[(int)size[0]][(int)size[1]];
    }

    public SimpleDenseDateMatrix2D(Date[] v) {
        this.values = new Date[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public Date getDate(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setDate(Date value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public Date getDate(int row, int column) {
        return this.values[row][column];
    }

    public void setDate(Date value, int row, int column) {
        this.values[row][column] = value;
    }

    public final Matrix transpose() {
        Date[][] result = new Date[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new SimpleDenseDateMatrix2D(result);
    }
}

