/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.ujmp.core.collections.AbstractMap;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.util.io.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiskMap<V>
extends AbstractMap<String, V>
implements Erasable {
    private static final long serialVersionUID = -8615077389159395747L;
    private File path = null;
    private boolean useGZip = true;
    private int maxDepth = 20;

    public AbstractDiskMap(File path, boolean useGZip) throws IOException {
        this.useGZip = useGZip;
        this.path = path;
    }

    public final File getPath() {
        if (this.path == null) {
            try {
                this.path = File.createTempFile("diskmap" + System.nanoTime(), "");
                this.path.delete();
                if (!this.path.exists()) {
                    this.path.mkdirs();
                }
            }
            catch (Exception e) {
                throw new MatrixException(e);
            }
        }
        return this.path;
    }

    @Override
    public final synchronized int size() {
        return AbstractDiskMap.countFiles(this.getPath());
    }

    private static int countFiles(File path) {
        int count = 0;
        File[] files = path.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                count = f.isDirectory() ? (count += AbstractDiskMap.countFiles(f)) : ++count;
                ++n2;
            }
        }
        return count;
    }

    private static final String convertKey(String key) {
        String result = "";
        int i = 0;
        while (i < key.length()) {
            char c = key.charAt(i);
            if (c < '0' || c > 'z' || c > 'Z' && c < 'a' || c > '9' && c < 'A') {
                c = '_';
            }
            result = String.valueOf(result) + c;
            ++i;
        }
        return result;
    }

    private final File getFileNameForKey(String key) {
        key = AbstractDiskMap.convertKey(key);
        String result = String.valueOf(this.getPath().getAbsolutePath()) + File.separator;
        int i = 0;
        while (i < this.maxDepth && i < key.length() - 1) {
            char c = key.charAt(i);
            result = String.valueOf(result) + c + File.separator;
            ++i;
        }
        result = String.valueOf(result) + key + ".dat";
        if (this.useGZip) {
            result = String.valueOf(result) + ".gz";
        }
        return new File(result);
    }

    @Override
    public final synchronized V remove(Object key) {
        V v = this.get(key);
        File file = this.getFileNameForKey((String)key);
        if (file.exists()) {
            file.delete();
        }
        return v;
    }

    @Override
    public final synchronized boolean containsKey(Object key) {
        File file = this.getFileNameForKey((String)key);
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    @Override
    public final Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        this.listFilesToSet(this.getPath(), set);
        return set;
    }

    private void listFilesToSet(File path, Set<String> set) {
        File[] files = path.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    this.listFilesToSet(f, set);
                } else {
                    String filename = f.getName();
                    if (filename.endsWith(".gz")) {
                        filename = filename.substring(0, filename.length() - 3);
                    }
                    if (filename.endsWith(".dat")) {
                        filename = filename.substring(0, filename.length() - 4);
                    }
                    set.add(filename);
                }
                ++n2;
            }
        }
    }

    @Override
    public final synchronized void clear() {
        try {
            this.erase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void erase() throws IOException {
        FileUtil.deleteRecursive(this.path);
    }

    public final void setPath(File path) {
        this.path = path;
    }

    @Override
    public final synchronized V put(String key, V value) {
        File file;
        block7: {
            block6: {
                try {
                    if (key != null) break block6;
                }
                catch (Exception e) {
                    throw new MatrixException("could not put object " + key, e);
                }
                return null;
            }
            file = this.getFileNameForKey(key);
            if (value != null || !file.exists()) break block7;
            file.delete();
            return null;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fo = new FileOutputStream(file);
        FilterOutputStream bo = new BufferedOutputStream(fo);
        if (this.useGZip) {
            bo = new GZIPOutputStream((OutputStream)bo, 8192);
        }
        this.write(bo, value);
        ((OutputStream)bo).close();
        fo.close();
        return null;
    }

    @Override
    public final synchronized V get(Object key) {
        File file;
        block4: {
            try {
                file = this.getFileNameForKey((String)key);
                if (file != null && file.exists()) break block4;
            }
            catch (Exception e) {
                throw new MatrixException("could not get object " + key, e);
            }
            return null;
        }
        V o = null;
        FileInputStream fi = new FileInputStream(file);
        FilterInputStream bi = new BufferedInputStream(fi);
        if (this.useGZip) {
            bi = new GZIPInputStream((InputStream)bi, 8192);
        }
        o = this.read(bi);
        ((InputStream)bi).close();
        fi.close();
        return o;
    }

    public abstract void write(OutputStream var1, V var2);

    public abstract V read(InputStream var1);
}

