/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.charmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.charmatrix.stub.AbstractDenseCharMatrix2D;
import org.ujmp.core.exceptions.MatrixException;

public class ArrayDenseCharMatrix2D
extends AbstractDenseCharMatrix2D {
    private static final long serialVersionUID = -172129670809500830L;
    private char[][] values = null;

    public ArrayDenseCharMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof ArrayDenseCharMatrix2D) {
            char[][] v = ((ArrayDenseCharMatrix2D)m).values;
            this.values = new char[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new char[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsChar(m.getAsChar(c), c);
            }
        }
    }

    public ArrayDenseCharMatrix2D(char[] ... v) {
        this.values = v;
    }

    public ArrayDenseCharMatrix2D(long ... size) {
        this.values = new char[(int)size[0]][(int)size[1]];
    }

    public ArrayDenseCharMatrix2D(char[] v) {
        this.values = new char[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public char getChar(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setChar(char value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public char getChar(int row, int column) {
        return this.values[row][column];
    }

    public void setChar(char value, int row, int column) {
        this.values[row][column] = value;
    }

    public final Matrix transpose() {
        char[][] result = new char[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new ArrayDenseCharMatrix2D(result);
    }
}

