/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasDoubleArray;
import org.ujmp.core.interfaces.HasDoubleArray2D;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.concurrent.PForEquidistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface PlusMatrix<T> {
    public static final PlusMatrix<Matrix> INSTANCE = new PlusMatrix<Matrix>(){

        @Override
        public void calc(Matrix source1, Matrix source2, Matrix target) {
            if (source1 instanceof DenseMatrix && source2 instanceof DenseMatrix && target instanceof DenseMatrix) {
                DENSEMATRIX.calc((DenseMatrix)source1, (DenseMatrix)source2, (DenseMatrix)target);
            } else if (source1 instanceof SparseMatrix && source2 instanceof SparseMatrix && target instanceof SparseMatrix) {
                SPARSEMATRIX.calc((SparseMatrix)source1, (SparseMatrix)source2, (SparseMatrix)target);
            } else {
                for (long[] c : source1.allCoordinates()) {
                    BigDecimal v1 = source1.getAsBigDecimal(c);
                    BigDecimal v2 = source2.getAsBigDecimal(c);
                    BigDecimal result = MathUtil.plus(v1, v2);
                    target.setAsBigDecimal(result, c);
                }
            }
        }
    };
    public static final PlusMatrix<DenseMatrix> DENSEMATRIX = new PlusMatrix<DenseMatrix>(){

        @Override
        public void calc(DenseMatrix source1, DenseMatrix source2, DenseMatrix target) {
            if (source1 instanceof DenseMatrix2D && source2 instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
                DENSEMATRIX2D.calc((DenseMatrix2D)source1, (DenseMatrix2D)source2, (DenseMatrix2D)target);
            } else {
                for (long[] c : source1.allCoordinates()) {
                    BigDecimal v1 = source1.getAsBigDecimal(c);
                    BigDecimal v2 = source2.getAsBigDecimal(c);
                    BigDecimal result = MathUtil.plus(v1, v2);
                    target.setAsBigDecimal(result, c);
                }
            }
        }
    };
    public static final PlusMatrix<SparseMatrix> SPARSEMATRIX = new PlusMatrix<SparseMatrix>(){

        @Override
        public void calc(SparseMatrix source1, SparseMatrix source2, SparseMatrix target) {
            for (long[] c : source1.availableCoordinates()) {
                BigDecimal svalue = source1.getAsBigDecimal(c);
                target.setAsBigDecimal(svalue, c);
            }
            for (long[] c : source2.availableCoordinates()) {
                BigDecimal v1 = target.getAsBigDecimal(c);
                BigDecimal v2 = source2.getAsBigDecimal(c);
                BigDecimal result = MathUtil.plus(v1, v2);
                target.setAsBigDecimal(result, c);
            }
        }
    };
    public static final PlusMatrix<DenseMatrix2D> DENSEMATRIX2D = new PlusMatrix<DenseMatrix2D>(){

        @Override
        public void calc(DenseMatrix2D source1, DenseMatrix2D source2, DenseMatrix2D target) {
            if (source1 instanceof DenseDoubleMatrix2D && source2 instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
                DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source1, (DenseDoubleMatrix2D)source2, (DenseDoubleMatrix2D)target);
            } else {
                int r = (int)source1.getRowCount();
                while (--r != -1) {
                    int c = (int)source1.getColumnCount();
                    while (--c != -1) {
                        BigDecimal v1 = source1.getAsBigDecimal(r, c);
                        BigDecimal v2 = source2.getAsBigDecimal(r, c);
                        BigDecimal result = MathUtil.plus(v1, v2);
                        target.setAsBigDecimal(result, r, c);
                    }
                }
            }
        }
    };
    public static final PlusMatrix<DenseDoubleMatrix2D> DENSEDOUBLEMATRIX2D = new PlusMatrix<DenseDoubleMatrix2D>(){

        @Override
        public void calc(DenseDoubleMatrix2D source1, DenseDoubleMatrix2D source2, DenseDoubleMatrix2D target) {
            if (source1 instanceof HasDoubleArray2D && source2 instanceof HasDoubleArray2D && target instanceof HasDoubleArray2D) {
                this.calc(((HasDoubleArray2D)((Object)source1)).getDoubleArray2D(), ((HasDoubleArray2D)((Object)source2)).getDoubleArray2D(), ((HasDoubleArray2D)((Object)target)).getDoubleArray2D());
            } else if (source1 instanceof HasDoubleArray && source2 instanceof HasDoubleArray && target instanceof HasDoubleArray) {
                this.calc(((HasDoubleArray)((Object)source1)).getDoubleArray(), ((HasDoubleArray)((Object)source2)).getDoubleArray(), ((HasDoubleArray)((Object)target)).getDoubleArray());
            } else {
                int r = (int)source1.getRowCount();
                while (--r != -1) {
                    int c = (int)source1.getColumnCount();
                    while (--c != -1) {
                        target.setDouble(source1.getDouble(r, c) + source2.getDouble(r, c), r, c);
                    }
                }
            }
        }

        @Override
        private void calc(final double[][] source1, final double[][] source2, final double[][] target) {
            int rows = source1.length;
            final int cols = source1[0].length;
            if (UJMPSettings.getNumberOfThreads() > 1 && rows >= 100 && cols >= 100) {
                new PForEquidistant(0, rows - 1, new Object[0]){

                    public void step(int i) {
                        double[] v1 = source1[i];
                        double[] v2 = source2[i];
                        double[] t = target[i];
                        int c = 0;
                        while (c < cols) {
                            t[c] = v1[c] + v2[c];
                            ++c;
                        }
                    }
                };
            } else {
                double[] v1 = null;
                double[] v2 = null;
                double[] t = null;
                int r = 0;
                while (r < rows) {
                    v1 = source1[r];
                    v2 = source2[r];
                    t = target[r];
                    int c = 0;
                    while (c < cols) {
                        t[c] = v1[c] + v2[c];
                        ++c;
                    }
                    ++r;
                }
            }
        }

        @Override
        private void calc(double[] source1, double[] source2, double[] target) {
            int length = source1.length;
            int i = 0;
            while (i < length) {
                target[i] = source1[i] + source2[i];
                ++i;
            }
        }
    };

    public void calc(T var1, T var2, T var3);
}

