/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.HasDoubleArray;
import org.ujmp.core.interfaces.HasDoubleArray2D;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.concurrent.PFor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Mtimes<S, T, U> {
    public static final Mtimes<Matrix, Matrix, Matrix> INSTANCE = new Mtimes<Matrix, Matrix, Matrix>(){

        @Override
        public void calc(Matrix source1, Matrix source2, Matrix target) {
            if (source1 instanceof DenseMatrix && source2 instanceof DenseMatrix && target instanceof DenseMatrix) {
                DENSEMATRIX.calc((DenseMatrix)source1, (DenseMatrix)source2, (DenseMatrix)target);
            } else if (source1 instanceof SparseMatrix) {
                SPARSEMATRIX1.calc((SparseMatrix)source1, source2, target);
            } else if (source2 instanceof SparseMatrix) {
                SPARSEMATRIX2.calc(source1, (SparseMatrix)source2, target);
            } else {
                this.gemm(1.0, source1, 1.0, source2, target);
            }
        }

        private void gemm(final double alpha, final Matrix A, final double beta, final Matrix B, final Matrix C) {
            final int m1RowCount = (int)A.getRowCount();
            final int m1ColumnCount = (int)A.getColumnCount();
            int m2RowCount = (int)B.getRowCount();
            int m2ColumnCount = (int)B.getColumnCount();
            if (m1ColumnCount != m2RowCount) {
                throw new MatrixException("matrices have wrong size");
            }
            if (alpha == 0.0 || beta == 0.0) {
                return;
            }
            if (C.getRowCount() >= 100L && C.getColumnCount() >= 100L) {
                new PFor(0, m2ColumnCount - 1, new Object[0]){

                    public void step(int i) {
                        int irow;
                        if (beta != 1.0) {
                            irow = 0;
                            while (irow < m1RowCount) {
                                C.setAsDouble(C.getAsDouble(irow, i) * beta, irow, i);
                                ++irow;
                            }
                        } else {
                            irow = 0;
                            while (irow < m1RowCount) {
                                C.setAsDouble(0.0, irow, i);
                                ++irow;
                            }
                        }
                        int lcol = 0;
                        while (lcol < m1ColumnCount) {
                            double temp = alpha * B.getAsDouble(lcol, i);
                            if (temp != 0.0) {
                                int irow2 = 0;
                                while (irow2 < m1RowCount) {
                                    C.setAsDouble(C.getAsDouble(irow2, i) + A.getAsDouble(irow2, lcol) * temp, irow2, i);
                                    ++irow2;
                                }
                            }
                            ++lcol;
                        }
                    }
                };
            } else {
                int i = 0;
                while (i < m2ColumnCount) {
                    int irow;
                    if (beta != 1.0) {
                        irow = 0;
                        while (irow < m1RowCount) {
                            C.setAsDouble(C.getAsDouble(irow, i) * beta, irow, i);
                            ++irow;
                        }
                    } else {
                        irow = 0;
                        while (irow < m1RowCount) {
                            C.setAsDouble(0.0, irow, i);
                            ++irow;
                        }
                    }
                    int lcol = 0;
                    while (lcol < m1ColumnCount) {
                        double temp = alpha * B.getAsDouble(lcol, i);
                        if (temp != 0.0) {
                            int irow2 = 0;
                            while (irow2 < m1RowCount) {
                                C.setAsDouble(C.getAsDouble(irow2, i) + A.getAsDouble(irow2, lcol) * temp, irow2, i);
                                ++irow2;
                            }
                        }
                        ++lcol;
                    }
                    ++i;
                }
            }
        }
    };
    public static final Mtimes<DenseMatrix, DenseMatrix, DenseMatrix> DENSEMATRIX = new Mtimes<DenseMatrix, DenseMatrix, DenseMatrix>(){

        @Override
        public void calc(DenseMatrix source1, DenseMatrix source2, DenseMatrix target) {
            if (source1 instanceof DenseMatrix2D && source2 instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
                DENSEMATRIX2D.calc((DenseMatrix2D)source1, (DenseMatrix2D)source2, (DenseMatrix2D)target);
            } else {
                this.gemm(1.0, source1, 1.0, source2, target);
            }
        }

        private void gemm(final double alpha, final DenseMatrix A, final double beta, final DenseMatrix B, final DenseMatrix C) {
            final int m1RowCount = (int)A.getRowCount();
            final int m1ColumnCount = (int)A.getColumnCount();
            int m2RowCount = (int)B.getRowCount();
            int m2ColumnCount = (int)B.getColumnCount();
            if (m1ColumnCount != m2RowCount) {
                throw new MatrixException("matrices have wrong size");
            }
            if (alpha == 0.0 || beta == 0.0) {
                return;
            }
            if (C.getRowCount() >= 100L && C.getColumnCount() >= 100L) {
                new PFor(0, m2ColumnCount - 1, new Object[0]){

                    public void step(int i) {
                        int irow;
                        if (beta != 1.0) {
                            irow = 0;
                            while (irow < m1RowCount) {
                                C.setAsDouble(C.getAsDouble(irow, i) * beta, irow, i);
                                ++irow;
                            }
                        } else {
                            irow = 0;
                            while (irow < m1RowCount) {
                                C.setAsDouble(0.0, irow, i);
                                ++irow;
                            }
                        }
                        int lcol = 0;
                        while (lcol < m1ColumnCount) {
                            double temp = alpha * B.getAsDouble(lcol, i);
                            if (temp != 0.0) {
                                int irow2 = 0;
                                while (irow2 < m1RowCount) {
                                    C.setAsDouble(C.getAsDouble(irow2, i) + A.getAsDouble(irow2, lcol) * temp, irow2, i);
                                    ++irow2;
                                }
                            }
                            ++lcol;
                        }
                    }
                };
            } else {
                int i = 0;
                while (i < m2ColumnCount) {
                    int irow;
                    if (beta != 1.0) {
                        irow = 0;
                        while (irow < m1RowCount) {
                            C.setAsDouble(C.getAsDouble(irow, i) * beta, irow, i);
                            ++irow;
                        }
                    } else {
                        irow = 0;
                        while (irow < m1RowCount) {
                            C.setAsDouble(0.0, irow, i);
                            ++irow;
                        }
                    }
                    int lcol = 0;
                    while (lcol < m1ColumnCount) {
                        double temp = alpha * B.getAsDouble(lcol, i);
                        if (temp != 0.0) {
                            int irow2 = 0;
                            while (irow2 < m1RowCount) {
                                C.setAsDouble(C.getAsDouble(irow2, i) + A.getAsDouble(irow2, lcol) * temp, irow2, i);
                                ++irow2;
                            }
                        }
                        ++lcol;
                    }
                    ++i;
                }
            }
        }
    };
    public static final Mtimes<SparseMatrix, Matrix, Matrix> SPARSEMATRIX1 = new Mtimes<SparseMatrix, Matrix, Matrix>(){

        @Override
        public void calc(SparseMatrix source1, Matrix source2, Matrix target) {
            target.clear();
            for (long[] c1 : source1.availableCoordinates()) {
                double v1 = source1.getAsDouble(c1);
                if (v1 == 0.0) continue;
                long col2 = source2.getColumnCount();
                while (--col2 != -1L) {
                    double v2 = source2.getAsDouble(c1[1], col2);
                    double temp = v1 * v2;
                    if (temp == 0.0) continue;
                    double v3 = target.getAsDouble(c1[0], col2);
                    target.setAsDouble(v3 + temp, c1[0], col2);
                }
            }
        }
    };
    public static final Mtimes<Matrix, SparseMatrix, Matrix> SPARSEMATRIX2 = new Mtimes<Matrix, SparseMatrix, Matrix>(){

        @Override
        public void calc(Matrix source1, SparseMatrix source2, Matrix target) {
            target.clear();
            for (long[] c2 : source2.availableCoordinates()) {
                double v2 = source2.getAsDouble(c2);
                if (v2 == 0.0) continue;
                long row1 = source1.getRowCount();
                while (--row1 != -1L) {
                    double v1 = source1.getAsDouble(row1, c2[0]);
                    double temp = v1 * v2;
                    if (temp == 0.0) continue;
                    double v3 = target.getAsDouble(row1, c2[1]);
                    target.setAsDouble(v3 + temp, row1, c2[1]);
                }
            }
        }
    };
    public static final Mtimes<DenseMatrix2D, DenseMatrix2D, DenseMatrix2D> DENSEMATRIX2D = new Mtimes<DenseMatrix2D, DenseMatrix2D, DenseMatrix2D>(){

        @Override
        public void calc(DenseMatrix2D source1, DenseMatrix2D source2, DenseMatrix2D target) {
            if (source1 instanceof DenseDoubleMatrix2D && source2 instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
                DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source1, (DenseDoubleMatrix2D)source2, (DenseDoubleMatrix2D)target);
            } else {
                this.gemm(1.0, source1, 1.0, source2, target);
            }
        }

        private void gemm(final double alpha, final DenseMatrix2D A, final double beta, final DenseMatrix2D B, final DenseMatrix2D C) {
            final int m1RowCount = (int)A.getRowCount();
            final int m1ColumnCount = (int)A.getColumnCount();
            int m2RowCount = (int)B.getRowCount();
            int m2ColumnCount = (int)B.getColumnCount();
            if (m1ColumnCount != m2RowCount) {
                throw new MatrixException("matrices have wrong size");
            }
            if (alpha == 0.0 || beta == 0.0) {
                return;
            }
            if (C.getRowCount() >= 100L && C.getColumnCount() >= 100L) {
                new PFor(0, m2ColumnCount - 1, new Object[0]){

                    public void step(int i) {
                        int irow;
                        if (beta != 1.0) {
                            irow = 0;
                            while (irow < m1RowCount) {
                                C.setAsDouble(C.getAsDouble(irow, i) * beta, irow, i);
                                ++irow;
                            }
                        } else {
                            irow = 0;
                            while (irow < m1RowCount) {
                                C.setAsDouble(0.0, irow, i);
                                ++irow;
                            }
                        }
                        int lcol = 0;
                        while (lcol < m1ColumnCount) {
                            double temp = alpha * B.getAsDouble(lcol, i);
                            if (temp != 0.0) {
                                int irow2 = 0;
                                while (irow2 < m1RowCount) {
                                    C.setAsDouble(C.getAsDouble(irow2, i) + A.getAsDouble(irow2, lcol) * temp, irow2, i);
                                    ++irow2;
                                }
                            }
                            ++lcol;
                        }
                    }
                };
            } else {
                int i = 0;
                while (i < m2ColumnCount) {
                    int irow;
                    if (beta != 1.0) {
                        irow = 0;
                        while (irow < m1RowCount) {
                            C.setAsDouble(C.getAsDouble(irow, i) * beta, irow, i);
                            ++irow;
                        }
                    } else {
                        irow = 0;
                        while (irow < m1RowCount) {
                            C.setAsDouble(0.0, irow, i);
                            ++irow;
                        }
                    }
                    int lcol = 0;
                    while (lcol < m1ColumnCount) {
                        double temp = alpha * B.getAsDouble(lcol, i);
                        if (temp != 0.0) {
                            int irow2 = 0;
                            while (irow2 < m1RowCount) {
                                C.setAsDouble(C.getAsDouble(irow2, i) + A.getAsDouble(irow2, lcol) * temp, irow2, i);
                                ++irow2;
                            }
                        }
                        ++lcol;
                    }
                    ++i;
                }
            }
        }
    };
    public static final Mtimes<DenseDoubleMatrix2D, DenseDoubleMatrix2D, DenseDoubleMatrix2D> DENSEDOUBLEMATRIX2D = new Mtimes<DenseDoubleMatrix2D, DenseDoubleMatrix2D, DenseDoubleMatrix2D>(){

        @Override
        public void calc(DenseDoubleMatrix2D source1, DenseDoubleMatrix2D source2, DenseDoubleMatrix2D target) {
            if (source1 instanceof HasDoubleArray2D && source2 instanceof HasDoubleArray2D && target instanceof HasDoubleArray2D) {
                this.calcDoubleArray2D(((HasDoubleArray2D)((Object)source1)).getDoubleArray2D(), ((HasDoubleArray2D)((Object)source2)).getDoubleArray2D(), ((HasDoubleArray2D)((Object)target)).getDoubleArray2D());
            } else if (source1 instanceof HasDoubleArray && source2 instanceof HasDoubleArray && target instanceof HasDoubleArray) {
                this.gemmDoubleArrayParallel(1.0, ((HasDoubleArray)((Object)source1)).getDoubleArray(), (int)source1.getRowCount(), (int)source1.getColumnCount(), 1.0, ((HasDoubleArray)((Object)source2)).getDoubleArray(), (int)source2.getRowCount(), (int)source2.getColumnCount(), ((HasDoubleArray)((Object)target)).getDoubleArray());
            } else {
                this.gemmDenseDoubleMatrix2D(1.0, source1, 1.0, source2, target);
            }
        }

        private void gemmDoubleArrayParallel(final double alpha, final double[] A, final int m1RowCount, final int m1ColumnCount, final double beta, final double[] B, int m2RowCount, int m2ColumnCount, final double[] C) {
            if (m1ColumnCount != m2RowCount) {
                throw new MatrixException("matrices have wrong size");
            }
            if (alpha == 0.0 || beta == 0.0) {
                return;
            }
            int i = C.length;
            while (--i != -1) {
                C[i] = 0.0;
            }
            if (C.length >= 10000) {
                new PFor(0, m2ColumnCount - 1, new Object[0]){

                    public void step(int i) {
                        int irow;
                        int jcolTimesM1RowCount = i * m1RowCount;
                        int jcolTimesM1ColumnCount = i * m1ColumnCount;
                        if (beta == 1.0) {
                            irow = 0;
                            while (irow < m1RowCount) {
                                C[irow + jcolTimesM1RowCount] = 0.0;
                                ++irow;
                            }
                        } else {
                            irow = 0;
                            while (irow < m1RowCount) {
                                int n = irow + jcolTimesM1RowCount;
                                C[n] = C[n] * beta;
                                ++irow;
                            }
                        }
                        int lcol = 0;
                        while (lcol < m1ColumnCount) {
                            double temp = alpha * B[lcol + jcolTimesM1ColumnCount];
                            if (temp != 0.0) {
                                int lcolTimesM1RowCount = lcol * m1RowCount;
                                int irow2 = 0;
                                while (irow2 < m1RowCount) {
                                    int n = irow2 + jcolTimesM1RowCount;
                                    C[n] = C[n] + A[irow2 + lcolTimesM1RowCount] * temp;
                                    ++irow2;
                                }
                            }
                            ++lcol;
                        }
                    }
                };
            } else {
                i = 0;
                while (i < m2ColumnCount) {
                    int irow;
                    int jcolTimesM1RowCount = i * m1RowCount;
                    int jcolTimesM1ColumnCount = i * m1ColumnCount;
                    if (beta == 1.0) {
                        irow = 0;
                        while (irow < m1RowCount) {
                            C[irow + jcolTimesM1RowCount] = 0.0;
                            ++irow;
                        }
                    } else {
                        irow = 0;
                        while (irow < m1RowCount) {
                            int n = irow + jcolTimesM1RowCount;
                            C[n] = C[n] * beta;
                            ++irow;
                        }
                    }
                    int lcol = 0;
                    while (lcol < m1ColumnCount) {
                        double temp = alpha * B[lcol + jcolTimesM1ColumnCount];
                        if (temp != 0.0) {
                            int lcolTimesM1RowCount = lcol * m1RowCount;
                            int irow2 = 0;
                            while (irow2 < m1RowCount) {
                                int n = irow2 + jcolTimesM1RowCount;
                                C[n] = C[n] + A[irow2 + lcolTimesM1RowCount] * temp;
                                ++irow2;
                            }
                        }
                        ++lcol;
                    }
                    ++i;
                }
            }
        }

        private void calcDoubleArray2D(final double[][] m1, final double[][] m2, final double[][] ret) {
            final int rowCount = m1.length;
            final int columnCount = m1[0].length;
            int retColumnCount = m2[0].length;
            if (columnCount != m2.length) {
                throw new MatrixException("matrices have wrong size");
            }
            if (rowCount * retColumnCount >= 500) {
                new PFor(0, retColumnCount - 1, new Object[0]){

                    public void step(int i) {
                        double[] columns = new double[columnCount];
                        int k = columnCount;
                        while (--k != -1) {
                            columns[k] = m2[k][i];
                        }
                        int r = rowCount;
                        while (--r != -1) {
                            double sum = 0.0;
                            double[] row = m1[r];
                            int k2 = columnCount;
                            while (--k2 != -1) {
                                sum += row[k2] * columns[k2];
                            }
                            ret[r][i] = sum;
                        }
                    }
                };
            } else {
                double[] columns = new double[columnCount];
                int c = retColumnCount;
                while (--c != -1) {
                    int k = columnCount;
                    while (--k != -1) {
                        columns[k] = m2[k][c];
                    }
                    int r = rowCount;
                    while (--r != -1) {
                        double sum = 0.0;
                        double[] row = m1[r];
                        int k2 = columnCount;
                        while (--k2 != -1) {
                            sum += row[k2] * columns[k2];
                        }
                        ret[r][c] = sum;
                    }
                }
            }
        }

        private void gemmDenseDoubleMatrix2D(final double alpha, final DenseDoubleMatrix2D A, final double beta, final DenseDoubleMatrix2D B, final DenseDoubleMatrix2D C) {
            final int m1RowCount = (int)A.getRowCount();
            final int m1ColumnCount = (int)A.getColumnCount();
            int m2RowCount = (int)B.getRowCount();
            int m2ColumnCount = (int)B.getColumnCount();
            if (m1ColumnCount != m2RowCount) {
                throw new MatrixException("matrices have wrong size");
            }
            if (alpha == 0.0 || beta == 0.0) {
                return;
            }
            if (C.getRowCount() >= 100L && C.getColumnCount() >= 100L) {
                new PFor(0, m2ColumnCount - 1, new Object[0]){

                    public void step(int i) {
                        int irow;
                        if (beta != 1.0) {
                            irow = 0;
                            while (irow < m1RowCount) {
                                C.setDouble(C.getDouble(irow, i) * beta, irow, i);
                                ++irow;
                            }
                        } else {
                            irow = 0;
                            while (irow < m1RowCount) {
                                C.setDouble(0.0, irow, i);
                                ++irow;
                            }
                        }
                        int lcol = 0;
                        while (lcol < m1ColumnCount) {
                            double temp = alpha * B.getDouble(lcol, i);
                            if (temp != 0.0) {
                                int irow2 = 0;
                                while (irow2 < m1RowCount) {
                                    C.setDouble(C.getDouble(irow2, i) + A.getDouble(irow2, lcol) * temp, irow2, i);
                                    ++irow2;
                                }
                            }
                            ++lcol;
                        }
                    }
                };
            } else {
                int i = 0;
                while (i < m2ColumnCount) {
                    int irow;
                    if (beta != 1.0) {
                        irow = 0;
                        while (irow < m1RowCount) {
                            C.setDouble(C.getDouble(irow, i) * beta, irow, i);
                            ++irow;
                        }
                    } else {
                        irow = 0;
                        while (irow < m1RowCount) {
                            C.setDouble(0.0, irow, i);
                            ++irow;
                        }
                    }
                    int lcol = 0;
                    while (lcol < m1ColumnCount) {
                        double temp = alpha * B.getDouble(lcol, i);
                        if (temp != 0.0) {
                            int irow2 = 0;
                            while (irow2 < m1RowCount) {
                                C.setDouble(C.getDouble(irow2, i) + A.getDouble(irow2, lcol) * temp, irow2, i);
                                ++irow2;
                            }
                        }
                        ++lcol;
                    }
                    ++i;
                }
            }
        }
    };

    public void calc(S var1, T var2, U var3);
}

