/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasDoubleArray;
import org.ujmp.core.interfaces.HasDoubleArray2D;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.concurrent.PForEquidistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MinusScalar<T> {
    public static final MinusScalar<Matrix> INSTANCE = new MinusScalar<Matrix>(){

        @Override
        public void calc(Matrix source, BigDecimal value, Matrix target) {
            if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
                DENSEMATRIX.calc((DenseMatrix)source, value, (DenseMatrix)target);
            } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
                SPARSEMATRIX.calc((SparseMatrix)source, value, (SparseMatrix)target);
            } else {
                for (long[] c : source.allCoordinates()) {
                    BigDecimal svalue = source.getAsBigDecimal(c);
                    BigDecimal result = MathUtil.minus(svalue, value);
                    target.setAsBigDecimal(result, c);
                }
            }
        }

        @Override
        public void calc(Matrix source, double value, Matrix target) {
            if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
                DENSEMATRIX.calc((DenseMatrix)source, value, (DenseMatrix)target);
            } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
                SPARSEMATRIX.calc((SparseMatrix)source, value, (SparseMatrix)target);
            } else {
                this.calc(source, new BigDecimal(value, MathUtil.getDefaultMathContext()), target);
            }
        }
    };
    public static final MinusScalar<DenseMatrix> DENSEMATRIX = new MinusScalar<DenseMatrix>(){

        @Override
        public void calc(DenseMatrix source, BigDecimal value, DenseMatrix target) {
            if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
                DENSEMATRIX2D.calc((DenseMatrix2D)source, value, (DenseMatrix2D)target);
            } else {
                for (long[] c : source.allCoordinates()) {
                    BigDecimal svalue = source.getAsBigDecimal(c);
                    BigDecimal result = MathUtil.minus(svalue, value);
                    target.setAsBigDecimal(result, c);
                }
            }
        }

        @Override
        public void calc(DenseMatrix source, double value, DenseMatrix target) {
            if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
                DENSEMATRIX2D.calc((DenseMatrix2D)source, value, (DenseMatrix2D)target);
            } else {
                this.calc(source, new BigDecimal(value, MathUtil.getDefaultMathContext()), target);
            }
        }
    };
    public static final MinusScalar<SparseMatrix> SPARSEMATRIX = new MinusScalar<SparseMatrix>(){

        @Override
        public void calc(SparseMatrix source, BigDecimal value, SparseMatrix target) {
            for (long[] c : source.availableCoordinates()) {
                BigDecimal svalue = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.minus(svalue, value);
                target.setAsBigDecimal(result, c);
            }
        }

        @Override
        public void calc(SparseMatrix source, double value, SparseMatrix target) {
            this.calc(source, new BigDecimal(value, MathUtil.getDefaultMathContext()), target);
        }
    };
    public static final MinusScalar<DenseMatrix2D> DENSEMATRIX2D = new MinusScalar<DenseMatrix2D>(){

        @Override
        public void calc(DenseMatrix2D source, BigDecimal value, DenseMatrix2D target) {
            if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
                DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, value, (DenseDoubleMatrix2D)target);
            } else {
                int r = (int)source.getRowCount();
                while (--r != -1) {
                    int c = (int)source.getColumnCount();
                    while (--c != -1) {
                        BigDecimal svalue = source.getAsBigDecimal(r, c);
                        BigDecimal result = MathUtil.minus(svalue, value);
                        target.setAsBigDecimal(result, r, c);
                    }
                }
            }
        }

        @Override
        public void calc(DenseMatrix2D source, double value, DenseMatrix2D target) {
            if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
                DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, value, (DenseDoubleMatrix2D)target);
            } else {
                this.calc(source, new BigDecimal(value, MathUtil.getDefaultMathContext()), target);
            }
        }
    };
    public static final MinusScalar<DenseDoubleMatrix2D> DENSEDOUBLEMATRIX2D = new MinusScalar<DenseDoubleMatrix2D>(){

        @Override
        public void calc(DenseDoubleMatrix2D source, BigDecimal value, DenseDoubleMatrix2D target) {
            this.calc(source, value.doubleValue(), target);
        }

        @Override
        public void calc(DenseDoubleMatrix2D source, double value, DenseDoubleMatrix2D target) {
            if (source instanceof HasDoubleArray2D && target instanceof HasDoubleArray2D) {
                this.calc(((HasDoubleArray2D)((Object)source)).getDoubleArray2D(), value, ((HasDoubleArray2D)((Object)target)).getDoubleArray2D());
            } else if (source instanceof HasDoubleArray && target instanceof HasDoubleArray) {
                this.calc(((HasDoubleArray)((Object)source)).getDoubleArray(), value, ((HasDoubleArray)((Object)target)).getDoubleArray());
            } else {
                int r = (int)source.getRowCount();
                while (--r != -1) {
                    int c = (int)source.getColumnCount();
                    while (--c != -1) {
                        target.setDouble(source.getDouble(r, c) - value, r, c);
                    }
                }
            }
        }

        @Override
        private void calc(final double[][] source, final double value, final double[][] target) {
            if (UJMPSettings.getNumberOfThreads() > 1 && source.length >= 100 && source[0].length >= 100) {
                new PForEquidistant(0, source.length - 1, new Object[0]){

                    public void step(int i) {
                        double[] tsource = source[i];
                        double[] ttarget = target[i];
                        int c = source[0].length;
                        while (--c != -1) {
                            ttarget[c] = tsource[c] - value;
                        }
                    }
                };
            } else {
                double[] tsource = null;
                double[] ttarget = null;
                int r = source.length;
                while (--r != -1) {
                    tsource = source[r];
                    ttarget = target[r];
                    int c = source[0].length;
                    while (--c != -1) {
                        ttarget[c] = tsource[c] - value;
                    }
                }
            }
        }

        @Override
        private void calc(double[] source, double value, double[] target) {
            int length = source.length;
            int i = 0;
            while (i < length) {
                target[i] = source[i] - value;
                ++i;
            }
        }
    };

    public void calc(T var1, BigDecimal var2, T var3);

    public void calc(T var1, double var2, T var4);
}

