/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasDoubleArray;
import org.ujmp.core.interfaces.HasDoubleArray2D;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.concurrent.PForEquidistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DivideScalar<T> {
    public static final DivideScalar<Matrix> INSTANCE = new DivideScalar<Matrix>(){

        @Override
        public void calc(Matrix source, BigDecimal divisor, Matrix target) {
            if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
                DENSEMATRIX.calc((DenseMatrix)source, divisor, (DenseMatrix)target);
            } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
                SPARSEMATRIX.calc((SparseMatrix)source, divisor, (SparseMatrix)target);
            } else {
                for (long[] c : source.allCoordinates()) {
                    BigDecimal value = source.getAsBigDecimal(c);
                    BigDecimal result = MathUtil.divide(value, divisor);
                    target.setAsBigDecimal(result, c);
                }
            }
        }

        @Override
        public void calc(Matrix source, double divisor, Matrix target) {
            if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
                DENSEMATRIX.calc((DenseMatrix)source, divisor, (DenseMatrix)target);
            } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
                SPARSEMATRIX.calc((SparseMatrix)source, divisor, (SparseMatrix)target);
            } else {
                this.calc(source, new BigDecimal(divisor, MathUtil.getDefaultMathContext()), target);
            }
        }
    };
    public static final DivideScalar<DenseMatrix> DENSEMATRIX = new DivideScalar<DenseMatrix>(){

        @Override
        public void calc(DenseMatrix source, BigDecimal divisor, DenseMatrix target) {
            if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
                DENSEMATRIX2D.calc((DenseMatrix2D)source, divisor, (DenseMatrix2D)target);
            } else {
                for (long[] c : source.allCoordinates()) {
                    BigDecimal value = source.getAsBigDecimal(c);
                    BigDecimal result = MathUtil.divide(value, divisor);
                    target.setAsBigDecimal(result, c);
                }
            }
        }

        @Override
        public void calc(DenseMatrix source, double divisor, DenseMatrix target) {
            if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
                DENSEMATRIX2D.calc((DenseMatrix2D)source, divisor, (DenseMatrix2D)target);
            } else {
                this.calc(source, new BigDecimal(divisor, MathUtil.getDefaultMathContext()), target);
            }
        }
    };
    public static final DivideScalar<SparseMatrix> SPARSEMATRIX = new DivideScalar<SparseMatrix>(){

        @Override
        public void calc(SparseMatrix source, BigDecimal divisor, SparseMatrix target) {
            for (long[] c : source.availableCoordinates()) {
                BigDecimal value = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.divide(value, divisor);
                target.setAsBigDecimal(result, c);
            }
        }

        @Override
        public void calc(SparseMatrix source, double divisor, SparseMatrix target) {
            this.calc(source, new BigDecimal(divisor, MathUtil.getDefaultMathContext()), target);
        }
    };
    public static final DivideScalar<DenseMatrix2D> DENSEMATRIX2D = new DivideScalar<DenseMatrix2D>(){

        @Override
        public void calc(DenseMatrix2D source, BigDecimal divisor, DenseMatrix2D target) {
            if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
                DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, divisor, (DenseDoubleMatrix2D)target);
            } else {
                int r = (int)source.getRowCount();
                while (--r != -1) {
                    int c = (int)source.getColumnCount();
                    while (--c != -1) {
                        BigDecimal value = source.getAsBigDecimal(r, c);
                        BigDecimal result = MathUtil.divide(value, divisor);
                        target.setAsBigDecimal(result, r, c);
                    }
                }
            }
        }

        @Override
        public void calc(DenseMatrix2D source, double divisor, DenseMatrix2D target) {
            if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
                DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, divisor, (DenseDoubleMatrix2D)target);
            } else {
                this.calc(source, new BigDecimal(divisor, MathUtil.getDefaultMathContext()), target);
            }
        }
    };
    public static final DivideScalar<DenseDoubleMatrix2D> DENSEDOUBLEMATRIX2D = new DivideScalar<DenseDoubleMatrix2D>(){

        @Override
        public void calc(DenseDoubleMatrix2D source, BigDecimal divisor, DenseDoubleMatrix2D target) {
            this.calc(source, divisor.doubleValue(), target);
        }

        @Override
        public void calc(DenseDoubleMatrix2D source, double divisor, DenseDoubleMatrix2D target) {
            if (source instanceof HasDoubleArray2D && target instanceof HasDoubleArray2D) {
                this.calc(((HasDoubleArray2D)((Object)source)).getDoubleArray2D(), divisor, ((HasDoubleArray2D)((Object)target)).getDoubleArray2D());
            } else if (source instanceof HasDoubleArray && target instanceof HasDoubleArray) {
                this.calc(((HasDoubleArray)((Object)source)).getDoubleArray(), divisor, ((HasDoubleArray)((Object)target)).getDoubleArray());
            } else {
                int r = (int)source.getRowCount();
                while (--r != -1) {
                    int c = (int)source.getColumnCount();
                    while (--c != -1) {
                        target.setDouble(source.getDouble(r, c) / divisor, r, c);
                    }
                }
            }
        }

        @Override
        private void calc(final double[][] source, final double divisor, final double[][] target) {
            if (UJMPSettings.getNumberOfThreads() > 1 && source.length >= 100 && source[0].length >= 100) {
                new PForEquidistant(0, source.length - 1, new Object[0]){

                    public void step(int i) {
                        double[] tsource = source[i];
                        double[] ttarget = target[i];
                        int c = source[0].length;
                        while (--c != -1) {
                            ttarget[c] = tsource[c] / divisor;
                        }
                    }
                };
            } else {
                double[] tsource = null;
                double[] ttarget = null;
                int r = source.length;
                while (--r != -1) {
                    tsource = source[r];
                    ttarget = target[r];
                    int c = source[0].length;
                    while (--c != -1) {
                        ttarget[c] = tsource[c] / divisor;
                    }
                }
            }
        }

        @Override
        private void calc(double[] source, double divisor, double[] target) {
            int length = source.length;
            int i = 0;
            while (i < length) {
                target[i] = source[i] / divisor;
                ++i;
            }
        }
    };

    public void calc(T var1, BigDecimal var2, T var3);

    public void calc(T var1, double var2, T var4);
}

