/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigdecimalmatrix.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.bigdecimalmatrix.BigDecimalMatrix;
import org.ujmp.core.bigdecimalmatrix.calculation.BigDecimalCalculation;
import org.ujmp.core.bigdecimalmatrix.impl.BigDecimalCalculationMatrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public abstract class AbstractBigDecimalCalculation
extends AbstractCalculation
implements BigDecimalCalculation {
    private static final long serialVersionUID = -8319068678826334197L;

    public AbstractBigDecimalCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractBigDecimalCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final BigDecimalMatrix calcNew() throws MatrixException {
        BigDecimalMatrix result = (BigDecimalMatrix)MatrixFactory.zeros(ValueType.BIGDECIMAL, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsBigDecimal(this.getBigDecimal(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public final BigDecimalMatrix calcLink() throws MatrixException {
        return new BigDecimalCalculationMatrix(this);
    }

    public final Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsBigDecimal(this.getBigDecimal(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setBigDecimal(BigDecimal value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.BIGDECIMAL;
    }
}

