/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import org.ujmp.core.Matrix;
import org.ujmp.core.benchmark.AbstractBenchmarkTask;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.util.GCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LUBenchmarkTask
extends AbstractBenchmarkTask {
    public LUBenchmarkTask(long benchmarkSeed, Class<? extends DoubleMatrix2D> matrixClass, BenchmarkConfig config) {
        super(benchmarkSeed, matrixClass, config.getLUSizes(), config);
    }

    @Override
    public double task(Class<? extends Matrix> matrixClass, long benchmarkSeed, int run, long[] size) {
        long t1;
        long t0;
        block5: {
            Matrix[] r;
            DoubleMatrix2D m;
            block4: {
                m = null;
                r = null;
                try {
                    m = BenchmarkUtil.createMatrix(matrixClass, size);
                    if (m.getClass().getName().startsWith("org.ujmp.core") || m.getClass().getDeclaredMethod("lu", new Class[0]) != null) break block4;
                    System.out.print("-");
                    System.out.flush();
                    return 0.0;
                }
                catch (Throwable e) {
                    System.out.print("e");
                    System.out.flush();
                    return Double.NaN;
                }
            }
            BenchmarkUtil.rand(benchmarkSeed, run, 0, m);
            GCUtil.purgeMemory();
            t0 = System.nanoTime();
            r = m.lu();
            t1 = System.nanoTime();
            if (r != null) break block5;
            System.out.print("e");
            System.out.flush();
            return Double.NaN;
        }
        return (double)(t1 - t0) / 1000000.0;
    }

    @Override
    public String getTaskName() {
        return "LU";
    }
}

