/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import java.net.Inet4Address;
import java.util.Random;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BenchmarkUtil {
    public static String getResultDir() {
        return "results/" + BenchmarkUtil.getHostName() + "/" + System.getProperty("os.name") + "/Java" + System.getProperty("java.version") + "/";
    }

    public static String getHostName() {
        try {
            return Inet4Address.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "localhost";
        }
    }

    public static void rand(long benchmarkSeed, int run, int id, DoubleMatrix2D matrix) {
        Random random = new Random(benchmarkSeed + (long)((run + 2) * 31 * 31) + (long)((id + 1) * 31));
        int rows = (int)matrix.getRowCount();
        int cols = (int)matrix.getColumnCount();
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                matrix.setDouble(random.nextDouble() - 0.5, r, c);
                ++c;
            }
            ++r;
        }
    }

    public static void randSymm(long benchmarkSeed, int run, int id, DoubleMatrix2D matrix) {
        Random random = new Random(benchmarkSeed + (long)((run + 2) * 31 * 31) + (long)((id + 1) * 31));
        int rows = (int)matrix.getRowCount();
        int cols = (int)matrix.getColumnCount();
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols && c <= r) {
                double f = random.nextDouble() - 0.5;
                matrix.setDouble(f - 0.5, r, c);
                matrix.setDouble(f - 0.5, c, r);
                ++c;
            }
            ++r;
        }
    }

    public static void randPositiveDefinite(long benchmarkSeed, int run, int id, DoubleMatrix2D matrix) {
        Random random = new Random(benchmarkSeed + (long)((run + 2) * 31 * 31) + (long)((id + 1) * 31));
        DefaultDenseDoubleMatrix2D temp = new DefaultDenseDoubleMatrix2D(matrix.getSize());
        int rows = (int)temp.getRowCount();
        int cols = (int)temp.getColumnCount();
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                temp.setDouble(random.nextDouble(), r, c);
                ++c;
            }
            ++r;
        }
        DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)temp.mtimes(temp.transpose());
        int r2 = 0;
        while (r2 < rows) {
            int c = 0;
            while (c < cols) {
                matrix.setDouble(result.getDouble(r2, c), r2, c);
                ++c;
            }
            ++r2;
        }
    }

    public static DoubleMatrix2D createMatrix(Class<? extends Matrix> matrixClass, long ... size) {
        try {
            return (DoubleMatrix2D)matrixClass.getConstructor(long[].class).newInstance(new Object[]{size});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DoubleMatrix2D createMatrix(Class<? extends Matrix> matrixClass, Matrix source) {
        try {
            return (DoubleMatrix2D)matrixClass.getConstructor(Matrix.class).newInstance(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

