/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import org.ujmp.core.Matrix;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.CholBenchmarkTask;
import org.ujmp.core.benchmark.EigBenchmarkTask;
import org.ujmp.core.benchmark.InvBenchmarkTask;
import org.ujmp.core.benchmark.LUBenchmarkTask;
import org.ujmp.core.benchmark.MatrixBenchmark;
import org.ujmp.core.benchmark.MtimesBenchmarkTask;
import org.ujmp.core.benchmark.PlusMatrixBenchmarkTask;
import org.ujmp.core.benchmark.QRBenchmarkTask;
import org.ujmp.core.benchmark.SVDBenchmarkTask;
import org.ujmp.core.benchmark.SolveSquareBenchmarkTask;
import org.ujmp.core.benchmark.SolveTallBenchmarkTask;
import org.ujmp.core.benchmark.TimesScalarBenchmarkTask;
import org.ujmp.core.benchmark.TransposeBenchmarkTask;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMatrix2DBenchmark
implements MatrixBenchmark {
    private static final BenchmarkConfig config = new BenchmarkConfig();
    private static long benchmarkSeed = 3345454363676L;

    public abstract DoubleMatrix2D createMatrix(long ... var1) throws MatrixException;

    public abstract DoubleMatrix2D createMatrix(Matrix var1) throws MatrixException;

    public AbstractMatrix2DBenchmark() {
        benchmarkSeed = System.currentTimeMillis();
    }

    @Override
    public final String getMatrixLabel() {
        return this.createMatrix(1L, 1L).getClass().getSimpleName();
    }

    @Override
    public final Class<? extends DoubleMatrix2D> getMatrixClass() {
        return this.createMatrix(1L, 1L).getClass();
    }

    @Override
    public final BenchmarkConfig getConfig() {
        return config;
    }

    @Override
    public final void run() {
        if (Runtime.getRuntime().maxMemory() < 1027604480L) {
            throw new MatrixException("You must start Java with more memory: -Xmx1024M");
        }
        try {
            System.out.println("===============================================================");
            System.out.println(this.createMatrix(1L, 1L).getClass().getSimpleName());
            System.out.println("===============================================================");
            long t0 = System.currentTimeMillis();
            if (config.isRunTimesScalar()) {
                new TimesScalarBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunPlusMatrix()) {
                new PlusMatrixBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunTranspose()) {
                new TransposeBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunMtimes()) {
                new MtimesBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunInv()) {
                new InvBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunSolveSquare()) {
                new SolveSquareBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunSolveTall()) {
                new SolveTallBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunSVD()) {
                new SVDBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunEig()) {
                new EigBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunChol()) {
                new CholBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunLU()) {
                new LUBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunQR()) {
                new QRBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            long t1 = System.currentTimeMillis();
            System.out.println();
            System.out.println("Benchmark runtime: " + StringUtil.duration(t1 - t0));
            System.out.println();
        }
        catch (UnsupportedClassVersionError e) {
            System.out.println("this library is not compatible with the current Java version");
            System.out.println("it cannot be included in the benchmark");
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("there was some error with this library");
            System.out.println("it cannot be included in the benchmark");
            e.printStackTrace();
        }
    }
}

