/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.annotation;

import org.ujmp.core.Matrix;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.annotation.DefaultAnnotation;
import org.ujmp.core.coordinates.Coordinates;

public abstract class AbstractAnnotation
implements Annotation {
    private static final long serialVersionUID = 2939231340832922069L;
    private long[] size = null;

    public AbstractAnnotation(long ... size) {
        this.size = Coordinates.copyOf(size);
    }

    public final long[] getSize() {
        return this.size;
    }

    public final int getDimensionCount() {
        return this.getSize().length;
    }

    public final Object getAxisAnnotation(int axis) {
        Matrix m = this.getDimensionMatrix(axis);
        return m.getMatrixAnnotation();
    }

    public final void setAxisAnnotation(int axis, Object value) {
        Matrix m = this.getDimensionMatrix(axis);
        m.setMatrixAnnotation(value);
    }

    public final String toString() {
        StringBuilder s = new StringBuilder();
        String EOL = System.getProperty("line.separator");
        s.append("Label: " + this.getMatrixAnnotation() + EOL);
        int i = 0;
        while (i < this.getDimensionCount()) {
            s.append("Dimension " + i + ":" + EOL);
            s.append(this.getDimensionMatrix(i));
            s.append(EOL);
            ++i;
        }
        return s.toString();
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getMatrixAnnotation() == null ? 0 : this.getMatrixAnnotation().hashCode());
        int i = 0;
        while (i < this.getDimensionCount()) {
            result = 31 * result + (this.getDimensionMatrix(i) == null ? 0 : this.getDimensionMatrix(i).hashCode());
            ++i;
        }
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultAnnotation other = (DefaultAnnotation)obj;
        if (this.getDimensionCount() != other.getDimensionCount()) {
            return false;
        }
        if (this.getMatrixAnnotation() == null ? other.getMatrixAnnotation() != null : !this.getMatrixAnnotation().equals(other.getMatrixAnnotation())) {
            return false;
        }
        int i = 0;
        while (i < this.getDimensionCount()) {
            if (this.getDimensionMatrix(i) == null ? other.getDimensionMatrix(i) != null : !this.getDimensionMatrix(i).equals(other.getDimensionMatrix(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public abstract Annotation clone();
}

