/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.complete.benchmark;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.ujmp.colt.benchmark.ColtDenseDoubleMatrix2DBenchmark;
import org.ujmp.commonsmath.benchmark.CommonsMathArrayDenseDoubleMatrix2DBenchmark;
import org.ujmp.commonsmath.benchmark.CommonsMathBlockDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.benchmark.AbstractMatrix2DBenchmark;
import org.ujmp.core.benchmark.ArrayDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.benchmark.DefaultDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.util.StringUtil;
import org.ujmp.ejml.benchmark.EJMLDenseDoubleMatrix2DBenchmark;
import org.ujmp.jama.benchmark.JamaDenseDoubleMatrix2DBenchmark;
import org.ujmp.jampack.benchmark.JampackDenseDoubleMatrix2DBenchmark;
import org.ujmp.jlinalg.benchmark.JLinAlgDenseDoubleMatrix2DBenchmark;
import org.ujmp.jmatharray.benchmark.JMathArrayDenseDoubleMatrix2DBenchmark;
import org.ujmp.jmatrices.benchmark.JMatricesDenseDoubleMatrix2DBenchmark;
import org.ujmp.jsci.benchmark.JSciDenseDoubleMatrix2DBenchmark;
import org.ujmp.jscience.benchmark.JScienceDenseDoubleMatrix2DBenchmark;
import org.ujmp.mantissa.benchmark.MantissaDenseDoubleMatrix2DBenchmark;
import org.ujmp.mtj.benchmark.MTJDenseDoubleMatrix2DBenchmark;
import org.ujmp.ojalgo.benchmark.OjalgoDenseDoubleMatrix2DBenchmark;
import org.ujmp.orbital.benchmark.OrbitalDenseDoubleMatrix2DBenchmark;
import org.ujmp.owlpack.benchmark.OwlpackDenseDoubleMatrix2DBenchmark;
import org.ujmp.parallelcolt.benchmark.ParallelColtDenseDoubleMatrix2DBenchmark;
import org.ujmp.sst.benchmark.SSTDenseDoubleMatrix2DBenchmark;
import org.ujmp.vecmath.benchmark.VecMathDenseDoubleMatrix2DBenchmark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteMatrixBenchmark
extends AbstractMatrix2DBenchmark {
    public List<AbstractMatrix2DBenchmark> getDenseBenchmarks() {
        ArrayList<AbstractMatrix2DBenchmark> list = new ArrayList<AbstractMatrix2DBenchmark>();
        if (this.getConfig().isRunVecMathDenseDoubleMatrix2D()) {
            list.add(new VecMathDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunDefaultDenseDoubleMatrix2D()) {
            list.add(new DefaultDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunArrayDenseDoubleMatrix2D()) {
            list.add(new ArrayDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunSSTDenseDoubleMatrix2D()) {
            list.add(new SSTDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunOwlpackDenseDoubleMatrix2D()) {
            list.add(new OwlpackDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunOrbitalDenseDoubleMatrix2D()) {
            list.add(new OrbitalDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunOjalgoDenseDoubleMatrix2D()) {
            list.add(new OjalgoDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunMTJDenseDoubleMatrix2D()) {
            list.add(new MTJDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunMantissaDenseDoubleMatrix2D()) {
            list.add(new MantissaDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJScienceDenseDoubleMatrix2D()) {
            list.add(new JScienceDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJSciDenseDoubleMatrix2D()) {
            list.add(new JSciDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJMatricesDenseDoubleMatrix2D()) {
            list.add(new JMatricesDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJMathArrayDenseDoubleMatrix2D()) {
            list.add(new JMathArrayDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJLinAlgDenseDoubleMatrix2D()) {
            list.add(new JLinAlgDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJampackDenseDoubleMatrix2D()) {
            list.add(new JampackDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJamaDenseDoubleMatrix2D()) {
            list.add(new JamaDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunEJMLDenseDoubleMatrix2D()) {
            list.add(new EJMLDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunCommonsMathBlockDenseDoubleMatrix2D()) {
            list.add(new CommonsMathBlockDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunCommonsMathArrayDenseDoubleMatrix2D()) {
            list.add(new CommonsMathArrayDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunColtDenseDoubleMatrix2D()) {
            list.add(new ColtDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunParallelColtDenseDoubleMatrix2D()) {
            list.add(new ParallelColtDenseDoubleMatrix2DBenchmark());
        }
        return list;
    }

    public void runAll() throws Exception {
        List<AbstractMatrix2DBenchmark> benchmarks = this.getDenseBenchmarks();
        long t0 = System.currentTimeMillis();
        int j = 0;
        while (j < benchmarks.size()) {
            AbstractMatrix2DBenchmark benchmark = benchmarks.get(j);
            benchmark.run();
            ++j;
        }
        long t1 = System.currentTimeMillis();
        System.out.println();
        System.out.println("Finished.");
        System.out.println("Total Time: " + StringUtil.duration(t1 - t0));
        System.out.println();
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        CompleteMatrixBenchmark mb = new CompleteMatrixBenchmark();
        mb.runAll();
        mb.evaluate();
    }

    public void evaluate() throws Exception {
        System.out.println("Evaluation");
        System.out.println("==========");
        System.out.println();
        File dir = new File(BenchmarkUtil.getResultDir());
        if (!dir.exists()) {
            throw new MatrixException("no results found");
        }
        HashMap<String, ArrayList<Matrix>> statistics = new HashMap<String, ArrayList<Matrix>>();
        List<File> dirs = Arrays.asList(dir.listFiles());
        Collections.sort(dirs);
        for (File f : dirs) {
            if (!f.isDirectory()) continue;
            String matrixName = f.getName();
            List<File> results = Arrays.asList(f.listFiles());
            Collections.sort(results);
            for (File r : results) {
                String benchmarkName = r.getName().replaceAll(".csv", "");
                Matrix data = MatrixFactory.importFromFile(FileFormat.CSV, r, "\t");
                data.setLabel(matrixName);
                ArrayList<Matrix> list = (List)statistics.get(benchmarkName);
                if (list == null) {
                    list = new ArrayList<Matrix>();
                    statistics.put(benchmarkName, list);
                }
                list.add(data);
            }
        }
        for (String benchmarkName : statistics.keySet()) {
            List list = (List)statistics.get(benchmarkName);
            ArrayList<Matrix> means = new ArrayList<Matrix>();
            ArrayList<Matrix> stds = new ArrayList<Matrix>();
            ArrayList<Matrix> mins = new ArrayList<Matrix>();
            ArrayList<Matrix> maxs = new ArrayList<Matrix>();
            for (Matrix m : list) {
                Matrix data = m.deleteRows(Calculation.Ret.NEW, 0L);
                Matrix columnLabels = m.selectRows(Calculation.Ret.NEW, 0L);
                Matrix mean = data.mean(Calculation.Ret.NEW, 0, true);
                mean.setLabel(String.valueOf(m.getLabel()) + "-" + benchmarkName + "-mean");
                mean.getAnnotation().setDimensionMatrix(0, columnLabels);
                means.add(mean);
                Matrix std = data.std(Calculation.Ret.NEW, 0, true);
                std.setLabel(String.valueOf(m.getLabel()) + "-" + benchmarkName + "-std");
                std.getAnnotation().setDimensionMatrix(0, columnLabels);
                stds.add(std);
                Matrix min = data.min(Calculation.Ret.NEW, 0);
                min.setLabel(String.valueOf(m.getLabel()) + "-" + benchmarkName + "-min");
                min.getAnnotation().setDimensionMatrix(0, columnLabels);
                mins.add(min);
                Matrix max = data.max(Calculation.Ret.NEW, 0);
                max.setLabel(String.valueOf(m.getLabel()) + "-" + benchmarkName + "-max");
                max.getAnnotation().setDimensionMatrix(0, columnLabels);
                maxs.add(max);
            }
            Matrix allmeans = null;
            try {
                allmeans = MatrixFactory.vertCat(means);
                allmeans.setLabel(String.valueOf(benchmarkName) + "-mean");
                DefaultListMatrix matrixLabels = new DefaultListMatrix();
                for (Matrix m : means) {
                    matrixLabels.add(m.getLabel().split("-")[0]);
                }
                allmeans.getAnnotation().setDimensionMatrix(1, matrixLabels);
            }
            catch (Exception e) {
                System.err.println("could not evaluate mean results for " + benchmarkName + ": " + e);
            }
            try {
                allmeans.showGUI();
            }
            catch (Exception e) {
                // empty catch block
            }
            Matrix firstMean = MatrixFactory.horCat(MatrixFactory.linkToValue(allmeans.getLabel()), allmeans.getAnnotation().getDimensionMatrix(0));
            Matrix lastMean = MatrixFactory.horCat(allmeans.getAnnotation().getDimensionMatrix(1), allmeans);
            Matrix matrixMean = MatrixFactory.vertCat(firstMean, lastMean);
            matrixMean.exportToFile(FileFormat.CSV, new File(String.valueOf(BenchmarkUtil.getResultDir()) + benchmarkName + "-mean.csv"), new Object[0]);
            try {
                matrixMean.exportToFile(FileFormat.XLS, new File(String.valueOf(BenchmarkUtil.getResultDir()) + benchmarkName + "-mean.xls"), new Object[0]);
            }
            catch (Exception mean) {
                // empty catch block
            }
            Matrix allstds = null;
            Matrix stdPercent = null;
            try {
                allstds = MatrixFactory.vertCat(stds);
                stdPercent = allstds.divide(allmeans).times(100.0);
                allstds.setLabel(String.valueOf(benchmarkName) + "-std");
                stdPercent.setLabel(String.valueOf(benchmarkName) + "-stdpercent");
                DefaultListMatrix stdLabels = new DefaultListMatrix();
                for (Matrix m : stds) {
                    stdLabels.add(m.getLabel().split("-")[0]);
                }
                allstds.getAnnotation().setDimensionMatrix(1, stdLabels);
                stdPercent.getAnnotation().setDimensionMatrix(1, stdLabels);
            }
            catch (Exception e) {
                System.err.println("could not evaluate std results for " + benchmarkName + ": " + e);
            }
            Matrix firstStd = MatrixFactory.horCat(MatrixFactory.linkToValue(allstds.getLabel()), allstds.getAnnotation().getDimensionMatrix(0));
            Matrix lastStd = MatrixFactory.horCat(allstds.getAnnotation().getDimensionMatrix(1), allstds);
            Matrix lastStdPercent = MatrixFactory.horCat(allstds.getAnnotation().getDimensionMatrix(1), stdPercent);
            Matrix matrixStd = MatrixFactory.vertCat(firstStd, lastStd);
            matrixStd.exportToFile(FileFormat.CSV, new File(String.valueOf(BenchmarkUtil.getResultDir()) + benchmarkName + "-std.csv"), new Object[0]);
            try {
                matrixStd.exportToFile(FileFormat.XLS, new File(String.valueOf(BenchmarkUtil.getResultDir()) + benchmarkName + "-std.xls"), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Matrix matrixStdPercent = MatrixFactory.vertCat(firstStd, lastStdPercent);
            matrixStdPercent.exportToFile(FileFormat.CSV, new File(String.valueOf(BenchmarkUtil.getResultDir()) + benchmarkName + "-stdpercent.csv"), new Object[0]);
            try {
                matrixStdPercent.exportToFile(FileFormat.XLS, new File(String.valueOf(BenchmarkUtil.getResultDir()) + benchmarkName + "-stdpercent.xls"), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Matrix allmins = null;
            try {
                allmins = MatrixFactory.vertCat(mins);
                allmins.setLabel(String.valueOf(benchmarkName) + "-min");
                DefaultListMatrix minLabels = new DefaultListMatrix();
                for (Matrix m : mins) {
                    minLabels.add(m.getLabel().split("-")[0]);
                }
                allmins.getAnnotation().setDimensionMatrix(1, minLabels);
            }
            catch (Exception e) {
                System.err.println("could not evaluate min results for " + benchmarkName + ": " + e);
            }
            Matrix firstMin = MatrixFactory.horCat(MatrixFactory.linkToValue(allmins.getLabel()), allmins.getAnnotation().getDimensionMatrix(0));
            Matrix lastMin = MatrixFactory.horCat(allmins.getAnnotation().getDimensionMatrix(1), allmins);
            Matrix matrixMin = MatrixFactory.vertCat(firstMin, lastMin);
            matrixMin.exportToFile(FileFormat.CSV, new File(String.valueOf(BenchmarkUtil.getResultDir()) + benchmarkName + "-min.csv"), new Object[0]);
            try {
                matrixMin.exportToFile(FileFormat.XLS, new File(String.valueOf(BenchmarkUtil.getResultDir()) + benchmarkName + "-min.xls"), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Matrix allmaxs = null;
            try {
                allmaxs = MatrixFactory.vertCat(maxs);
                allmaxs.setLabel(String.valueOf(benchmarkName) + "-max");
                DefaultListMatrix maxLabels = new DefaultListMatrix();
                for (Matrix m : maxs) {
                    maxLabels.add(m.getLabel().split("-")[0]);
                }
                allmaxs.getAnnotation().setDimensionMatrix(1, maxLabels);
            }
            catch (Exception e) {
                System.err.println("could not evaluate max results for " + benchmarkName + ": " + e);
            }
            Matrix firstMax = MatrixFactory.horCat(MatrixFactory.linkToValue(allmaxs.getLabel()), allmaxs.getAnnotation().getDimensionMatrix(0));
            Matrix lastMax = MatrixFactory.horCat(allmins.getAnnotation().getDimensionMatrix(1), allmaxs);
            Matrix matrixMax = MatrixFactory.vertCat(firstMax, lastMax);
            matrixMax.exportToFile(FileFormat.CSV, new File(String.valueOf(BenchmarkUtil.getResultDir()) + benchmarkName + "-max.csv"), new Object[0]);
            try {
                matrixMax.exportToFile(FileFormat.XLS, new File(String.valueOf(BenchmarkUtil.getResultDir()) + benchmarkName + "-max.xls"), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println(allmeans);
            System.out.println();
        }
    }

    @Override
    public DoubleMatrix2D createMatrix(long ... size) throws MatrixException {
        return null;
    }

    @Override
    public DoubleMatrix2D createMatrix(Matrix source) throws MatrixException {
        return null;
    }
}

