/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.commonsmath;

import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.ujmp.commonsmath.CommonsMathArrayDenseDoubleMatrix2D;
import org.ujmp.commonsmath.CommonsMathBlockDenseDoubleMatrix2D;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.factory.AbstractDoubleMatrix2DFactory;
import org.ujmp.core.exceptions.MatrixException;

public class CommonsMathDenseDoubleMatrix2DFactory
extends AbstractDoubleMatrix2DFactory {
    private static final long serialVersionUID = -4938756141859017575L;
    public static final CommonsMathDenseDoubleMatrix2DFactory INSTANCE = new CommonsMathDenseDoubleMatrix2DFactory();

    public DenseDoubleMatrix2D dense(long rows, long columns) throws MatrixException {
        return new CommonsMathArrayDenseDoubleMatrix2D(rows, columns);
    }

    public DenseDoubleMatrix2D dense(Array2DRowRealMatrix matrix) throws MatrixException {
        return new CommonsMathArrayDenseDoubleMatrix2D(matrix);
    }

    public DenseDoubleMatrix2D dense(BlockRealMatrix matrix) throws MatrixException {
        return new CommonsMathBlockDenseDoubleMatrix2D(matrix);
    }

    public Matrix dense(RealMatrix matrix) {
        if (matrix instanceof BlockRealMatrix) {
            return this.dense((BlockRealMatrix)matrix);
        }
        if (matrix instanceof Array2DRowRealMatrix) {
            return this.dense((Array2DRowRealMatrix)matrix);
        }
        throw new MatrixException("not available");
    }
}

