/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.commonsmath;

import org.apache.commons.math.linear.CholeskyDecompositionImpl;
import org.apache.commons.math.linear.EigenDecompositionImpl;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.QRDecompositionImpl;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.SingularValueDecompositionImpl;
import org.ujmp.commonsmath.CommonsMathDenseDoubleMatrix2DFactory;
import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommonsMathDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<RealMatrix> {
    private static final long serialVersionUID = -1161807620507675926L;
    private RealMatrix matrix = null;

    public AbstractCommonsMathDenseDoubleMatrix2D(RealMatrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public RealMatrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(RealMatrix object) {
        this.matrix = object;
    }

    @Override
    public double getDouble(long row, long column) throws MatrixException {
        return this.matrix.getEntry((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) throws MatrixException {
        return this.matrix.getEntry(row, column);
    }

    @Override
    public void setDouble(double value, long row, long column) throws MatrixException {
        this.matrix.setEntry((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) throws MatrixException {
        this.matrix.setEntry(row, column, value);
    }

    @Override
    public long[] getSize() {
        long[] lArray;
        if (this.matrix == null) {
            lArray = Coordinates.ZERO2D;
        } else {
            long[] lArray2 = new long[2];
            lArray2[0] = this.matrix.getRowDimension();
            lArray = lArray2;
            lArray2[1] = this.matrix.getColumnDimension();
        }
        return lArray;
    }

    @Override
    public Matrix transpose() {
        return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.transpose());
    }

    @Override
    public Matrix inv() {
        return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(new LUDecompositionImpl(this.matrix).getSolver().getInverse());
    }

    @Override
    public Matrix[] lu() {
        LUDecompositionImpl lu = new LUDecompositionImpl(this.matrix);
        Matrix l = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(lu.getL());
        Matrix u = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(lu.getU());
        return new Matrix[]{l, u};
    }

    @Override
    public Matrix[] qr() {
        QRDecompositionImpl qr = new QRDecompositionImpl(this.matrix);
        Matrix q = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(qr.getQ());
        Matrix r = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(qr.getR());
        return new Matrix[]{q, r};
    }

    @Override
    public Matrix[] svd() {
        SingularValueDecompositionImpl svd = new SingularValueDecompositionImpl(this.matrix);
        Matrix u = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(svd.getU());
        Matrix s = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(svd.getS());
        Matrix v = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(svd.getV());
        return new Matrix[]{u, s, v};
    }

    @Override
    public Matrix[] eig() {
        EigenDecompositionImpl evd = new EigenDecompositionImpl(this.matrix, (double)1.110223E-16f);
        Matrix v = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(evd.getV());
        Matrix d = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(evd.getD());
        return new Matrix[]{v, d};
    }

    @Override
    public Matrix chol() {
        try {
            CholeskyDecompositionImpl chol = new CholeskyDecompositionImpl(this.matrix);
            Matrix l = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(chol.getL());
            return l;
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public Matrix mtimes(Matrix m2) {
        if (m2 instanceof AbstractCommonsMathDenseDoubleMatrix2D) {
            return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.multiply(((AbstractCommonsMathDenseDoubleMatrix2D)m2).matrix));
        }
        return super.mtimes(m2);
    }

    @Override
    public Matrix plus(Matrix m2) {
        if (m2 instanceof AbstractCommonsMathDenseDoubleMatrix2D) {
            return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.add(((AbstractCommonsMathDenseDoubleMatrix2D)m2).matrix));
        }
        return super.plus(m2);
    }

    @Override
    public Matrix minus(Matrix m2) {
        if (m2 instanceof AbstractCommonsMathDenseDoubleMatrix2D) {
            return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.subtract(((AbstractCommonsMathDenseDoubleMatrix2D)m2).matrix));
        }
        return super.minus(m2);
    }

    @Override
    public Matrix times(double value) {
        return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.scalarMultiply(value));
    }

    @Override
    public Matrix divide(double value) {
        return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.scalarMultiply(1.0 / value));
    }

    @Override
    public Matrix plus(double value) {
        return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.scalarAdd(value));
    }

    @Override
    public Matrix minus(double value) {
        return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.scalarAdd(-value));
    }

    @Override
    public Matrix solve(Matrix b) {
        if (b instanceof AbstractCommonsMathDenseDoubleMatrix2D) {
            AbstractCommonsMathDenseDoubleMatrix2D b2 = (AbstractCommonsMathDenseDoubleMatrix2D)b;
            if (this.isSquare()) {
                RealMatrix ret = new LUDecompositionImpl(this.matrix).getSolver().solve(b2.matrix);
                return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(ret);
            }
            RealMatrix ret = new QRDecompositionImpl(this.matrix).getSolver().solve(b2.matrix);
            return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(ret);
        }
        return super.solve(b);
    }
}

