/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.colt;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import cern.colt.matrix.linalg.LUDecomposition;
import cern.colt.matrix.linalg.QRDecomposition;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import cern.colt.matrix.linalg.SmpBlas;
import cern.jet.math.Functions;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColtDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<DenseDoubleMatrix2D> {
    private static final long serialVersionUID = -3223474248020842822L;
    private DenseDoubleMatrix2D matrix = null;

    public ColtDenseDoubleMatrix2D(long ... size) {
        this.matrix = new DenseDoubleMatrix2D((int)size[0], (int)size[1]);
    }

    public ColtDenseDoubleMatrix2D(DoubleMatrix2D m) {
        this.matrix = m instanceof DenseDoubleMatrix2D ? (DenseDoubleMatrix2D)m : new DenseDoubleMatrix2D(m.toArray());
    }

    public ColtDenseDoubleMatrix2D(DenseDoubleMatrix2D m) {
        this.matrix = m;
    }

    public ColtDenseDoubleMatrix2D(Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setAsDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getQuick((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getQuick(row, column);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.rows(), this.matrix.columns()};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setQuick((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setQuick(row, column, value);
    }

    @Override
    public DenseDoubleMatrix2D getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(DenseDoubleMatrix2D object) {
        this.matrix = object;
    }

    @Override
    public Matrix transpose() {
        return new ColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.viewDice().copy());
    }

    @Override
    public Matrix inv() {
        return new ColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)new Algebra().inverse((DoubleMatrix2D)this.matrix));
    }

    @Override
    public Matrix solve(Matrix b) {
        if (b instanceof ColtDenseDoubleMatrix2D) {
            ColtDenseDoubleMatrix2D b2 = (ColtDenseDoubleMatrix2D)b;
            if (this.isSquare()) {
                DoubleMatrix2D ret = new LUDecomposition((DoubleMatrix2D)this.matrix).solve((DoubleMatrix2D)b2.matrix);
                return new ColtDenseDoubleMatrix2D(ret);
            }
            DoubleMatrix2D ret = new QRDecomposition((DoubleMatrix2D)this.matrix).solve((DoubleMatrix2D)b2.matrix);
            return new ColtDenseDoubleMatrix2D(ret);
        }
        return super.solve(b);
    }

    @Override
    public Matrix plus(double value) {
        return new ColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy().assign(Functions.plus((double)value)));
    }

    @Override
    public Matrix minus(double value) {
        return new ColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy().assign(Functions.minus((double)value)));
    }

    @Override
    public Matrix times(double value) {
        return new ColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy().assign(Functions.mult((double)value)));
    }

    @Override
    public Matrix divide(double value) {
        return new ColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy().assign(Functions.div((double)value)));
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof ColtDenseDoubleMatrix2D) {
            DenseDoubleMatrix2D ret = new DenseDoubleMatrix2D((int)this.getRowCount(), (int)m.getColumnCount());
            this.matrix.zMult((DoubleMatrix2D)((ColtDenseDoubleMatrix2D)m).matrix, (DoubleMatrix2D)ret);
            return new ColtDenseDoubleMatrix2D(ret);
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof ColtDenseDoubleMatrix2D) {
            DenseDoubleMatrix2D ret = new DenseDoubleMatrix2D((int)this.getRowCount(), (int)m.getColumnCount());
            ret.assign((DoubleMatrix2D)this.matrix);
            SmpBlas.smpBlas.daxpy(1.0, (DoubleMatrix2D)((ColtDenseDoubleMatrix2D)m).getWrappedObject(), (DoubleMatrix2D)ret);
            return new ColtDenseDoubleMatrix2D(ret);
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof ColtDenseDoubleMatrix2D) {
            DenseDoubleMatrix2D ret = new DenseDoubleMatrix2D((int)this.getRowCount(), (int)m.getColumnCount());
            ret.assign((DoubleMatrix2D)this.matrix);
            SmpBlas.smpBlas.daxpy(-1.0, (DoubleMatrix2D)((ColtDenseDoubleMatrix2D)m).getWrappedObject(), (DoubleMatrix2D)ret);
            return new ColtDenseDoubleMatrix2D(ret);
        }
        return super.plus(m);
    }

    @Override
    public Matrix[] svd() {
        if (this.getColumnCount() > this.getRowCount()) {
            SingularValueDecomposition svd = new SingularValueDecomposition(this.matrix.viewDice());
            ColtDenseDoubleMatrix2D u = new ColtDenseDoubleMatrix2D(svd.getV());
            ColtDenseDoubleMatrix2D s = new ColtDenseDoubleMatrix2D(svd.getS());
            ColtDenseDoubleMatrix2D v = new ColtDenseDoubleMatrix2D(svd.getU());
            return new Matrix[]{u, s, v};
        }
        SingularValueDecomposition svd = new SingularValueDecomposition((DoubleMatrix2D)this.matrix);
        ColtDenseDoubleMatrix2D u = new ColtDenseDoubleMatrix2D(svd.getU());
        ColtDenseDoubleMatrix2D s = new ColtDenseDoubleMatrix2D(svd.getS());
        ColtDenseDoubleMatrix2D v = new ColtDenseDoubleMatrix2D(svd.getV());
        return new Matrix[]{u, s, v};
    }

    @Override
    public Matrix[] qr() {
        if (this.getColumnCount() > this.getRowCount()) {
            throw new MatrixException("matrix size must be m>=n");
        }
        QRDecomposition qr = new QRDecomposition((DoubleMatrix2D)this.matrix);
        ColtDenseDoubleMatrix2D q = new ColtDenseDoubleMatrix2D(qr.getQ());
        ColtDenseDoubleMatrix2D r = new ColtDenseDoubleMatrix2D(qr.getR());
        return new Matrix[]{q, r};
    }

    @Override
    public Matrix[] eig() {
        EigenvalueDecomposition eig = new EigenvalueDecomposition((DoubleMatrix2D)this.matrix);
        ColtDenseDoubleMatrix2D v = new ColtDenseDoubleMatrix2D(eig.getV());
        ColtDenseDoubleMatrix2D d = new ColtDenseDoubleMatrix2D(eig.getD());
        return new Matrix[]{v, d};
    }

    @Override
    public Matrix chol() {
        CholeskyDecomposition eig = new CholeskyDecomposition((DoubleMatrix2D)this.matrix);
        ColtDenseDoubleMatrix2D r = new ColtDenseDoubleMatrix2D(eig.getL());
        return r;
    }

    @Override
    public Matrix[] lu() {
        if (this.getColumnCount() > this.getRowCount()) {
            throw new MatrixException("only supported for m>=n");
        }
        LUDecomposition lu = new LUDecomposition((DoubleMatrix2D)this.matrix);
        ColtDenseDoubleMatrix2D l = new ColtDenseDoubleMatrix2D(lu.getL());
        ColtDenseDoubleMatrix2D u = new ColtDenseDoubleMatrix2D(lu.getU().viewPart(0, 0, (int)this.getColumnCount(), (int)this.getColumnCount()));
        int[] piv = lu.getPivot();
        int m = (int)this.getRowCount();
        ColtDenseDoubleMatrix2D p = new ColtDenseDoubleMatrix2D(m, m);
        int i = 0;
        while (i < m) {
            p.setAsDouble(1.0, new long[]{i, piv[i]});
            ++i;
        }
        return new Matrix[]{l, u, p};
    }

    @Override
    public Matrix copy() {
        ColtDenseDoubleMatrix2D m = new ColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy());
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }
}

