/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.mtj;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import no.uib.cipr.matrix.DenseCholesky;
import no.uib.cipr.matrix.DenseLU;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.EVD;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.QR;
import org.netlib.blas.Dgemm;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.mtj.calculation.Inv;
import org.ujmp.mtj.calculation.SVD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<DenseMatrix> {
    private static final long serialVersionUID = -2386081646062313108L;
    private transient DenseMatrix matrix = null;

    public MTJDenseDoubleMatrix2D(DenseMatrix m) {
        this.matrix = m;
    }

    public MTJDenseDoubleMatrix2D(Matrix m) {
        this.matrix = new DenseMatrix(m);
    }

    public MTJDenseDoubleMatrix2D(org.ujmp.core.Matrix m) throws MatrixException {
        this.matrix = m instanceof MTJDenseDoubleMatrix2D ? ((MTJDenseDoubleMatrix2D)m).matrix.copy() : new DenseMatrix(m.toDoubleArray());
    }

    public MTJDenseDoubleMatrix2D(long ... size) {
        this.matrix = new DenseMatrix((int)size[0], (int)size[1]);
    }

    @Override
    public org.ujmp.core.Matrix[] svd() throws MatrixException {
        return SVD.INSTANCE.calc(this);
    }

    @Override
    public org.ujmp.core.Matrix[] qr() throws MatrixException {
        if (this.getRowCount() >= this.getColumnCount()) {
            try {
                QR qr = QR.factorize((Matrix)this.getWrappedObject());
                MTJDenseDoubleMatrix2D q = new MTJDenseDoubleMatrix2D(qr.getQ());
                MTJDenseDoubleMatrix2D r = new MTJDenseDoubleMatrix2D((Matrix)qr.getR());
                return new org.ujmp.core.Matrix[]{q, r};
            }
            catch (Exception e) {
                throw new MatrixException(e);
            }
        }
        throw new MatrixException("only allowed for matrices m>=n");
    }

    @Override
    public org.ujmp.core.Matrix[] lu() throws MatrixException {
        try {
            DenseLU lu = DenseLU.factorize((Matrix)this.getWrappedObject());
            MTJDenseDoubleMatrix2D l = new MTJDenseDoubleMatrix2D((Matrix)lu.getL());
            MTJDenseDoubleMatrix2D u = new MTJDenseDoubleMatrix2D((Matrix)lu.getU());
            int m = (int)this.getRowCount();
            int[] piv = lu.getPivots();
            MTJDenseDoubleMatrix2D p = new MTJDenseDoubleMatrix2D(m, m);
            p.eye(Calculation.Ret.ORIG);
            return new org.ujmp.core.Matrix[]{l, u, p};
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public org.ujmp.core.Matrix chol() throws MatrixException {
        try {
            DenseCholesky chol = DenseCholesky.factorize((Matrix)this.getWrappedObject());
            MTJDenseDoubleMatrix2D l = new MTJDenseDoubleMatrix2D((Matrix)chol.getL());
            return l;
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public org.ujmp.core.Matrix[] eig() throws MatrixException {
        try {
            EVD evd = EVD.factorize((Matrix)this.getWrappedObject());
            MTJDenseDoubleMatrix2D v = new MTJDenseDoubleMatrix2D(evd.getRightEigenvectors());
            int m = (int)this.getRowCount();
            double[] evds = evd.getRealEigenvalues();
            MTJDenseDoubleMatrix2D d = new MTJDenseDoubleMatrix2D(m, m);
            int i = 0;
            while (i < m) {
                d.setAsDouble(evds[i], new long[]{i, i});
                ++i;
            }
            return new org.ujmp.core.Matrix[]{v, d};
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getData()[(int)(row + column * (long)this.matrix.numRows())];
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getData()[row + column * this.matrix.numRows()];
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.numRows(), this.matrix.numColumns()};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.getData()[(int)(row + column * (long)this.matrix.numRows())] = value;
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.getData()[row + column * this.matrix.numRows()] = value;
    }

    @Override
    public org.ujmp.core.Matrix transpose() {
        DenseMatrix ret = new DenseMatrix((int)this.getColumnCount(), (int)this.getRowCount());
        return new MTJDenseDoubleMatrix2D((DenseMatrix)this.matrix.transpose((Matrix)ret));
    }

    @Override
    public org.ujmp.core.Matrix inv() {
        return new Inv((org.ujmp.core.Matrix)this).calcNew();
    }

    @Override
    public DenseMatrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(DenseMatrix object) {
        this.matrix = object;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        double[][] values = (double[][])s.readObject();
        this.matrix = new DenseMatrix(values);
    }

    private void writeObject(ObjectOutputStream s) throws IOException, MatrixException {
        s.defaultWriteObject();
        s.writeObject(this.toDoubleArray());
    }

    @Override
    public org.ujmp.core.Matrix mtimes(org.ujmp.core.Matrix m2) throws MatrixException {
        if (m2 instanceof MTJDenseDoubleMatrix2D) {
            DenseMatrix a = this.matrix;
            DenseMatrix b = ((MTJDenseDoubleMatrix2D)m2).getWrappedObject();
            DenseMatrix c = new DenseMatrix(a.numRows(), b.numColumns());
            try {
                a.mult((Matrix)b, (Matrix)c);
                return new MTJDenseDoubleMatrix2D(c);
            }
            catch (Exception e) {
                double[] Bd = b.getData();
                double[] Cd = c.getData();
                Dgemm.dgemm((String)"N", (String)"N", (int)c.numRows(), (int)c.numColumns(), (int)a.numColumns(), (double)1.0, (double[])a.getData(), (int)0, (int)Math.max(1, a.numRows()), (double[])Bd, (int)0, (int)Math.max(1, b.numRows()), (double)1.0, (double[])Cd, (int)0, (int)Math.max(1, c.numRows()));
                return new MTJDenseDoubleMatrix2D(c);
            }
        }
        return super.mtimes(m2);
    }

    @Override
    public org.ujmp.core.Matrix plus(org.ujmp.core.Matrix m2) throws MatrixException {
        if (m2 instanceof MTJDenseDoubleMatrix2D) {
            DenseMatrix ret = this.matrix.copy();
            ret.add((Matrix)((MTJDenseDoubleMatrix2D)m2).getWrappedObject());
            return new MTJDenseDoubleMatrix2D(ret);
        }
        return super.plus(m2);
    }

    @Override
    public org.ujmp.core.Matrix times(double f) throws MatrixException {
        DenseMatrix ret = this.matrix.copy();
        ret.scale(f);
        return new MTJDenseDoubleMatrix2D(ret);
    }

    @Override
    public org.ujmp.core.Matrix divide(double f) throws MatrixException {
        DenseMatrix ret = this.matrix.copy();
        ret.scale(1.0 / f);
        return new MTJDenseDoubleMatrix2D(ret);
    }

    @Override
    public org.ujmp.core.Matrix copy() {
        MTJDenseDoubleMatrix2D m = new MTJDenseDoubleMatrix2D(this.matrix.copy());
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    @Override
    public org.ujmp.core.Matrix solve(org.ujmp.core.Matrix b) {
        if (b instanceof MTJDenseDoubleMatrix2D) {
            MTJDenseDoubleMatrix2D b2 = (MTJDenseDoubleMatrix2D)b;
            DenseMatrix x = new DenseMatrix((int)this.getColumnCount(), (int)b2.getColumnCount());
            this.matrix.solve((Matrix)b2.matrix, (Matrix)x);
            return new MTJDenseDoubleMatrix2D(x);
        }
        return super.solve(b);
    }
}

