/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.lucene;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.ujmp.core.collections.AbstractMap;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.util.Base64;
import org.ujmp.core.util.SerializationUtil;
import org.ujmp.core.util.io.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Flushable,
Closeable,
Erasable,
Serializable {
    private static final long serialVersionUID = 8998898900190996038L;
    private static final String KEYSTRING = "KS";
    private static final String KEYDATA = "KD";
    private static final String VALUESTRING = "VS";
    private static final String VALUEDATA = "VD";
    private transient Directory directory = null;
    private transient IndexWriter indexWriter = null;
    private transient IndexSearcher indexSearcher = null;
    private static final int MAXSIZE = 1000000;
    private boolean readOnly = false;
    private transient File path = null;
    private transient Analyzer analyzer = null;

    public LuceneMap() throws IOException {
        this(null, false);
    }

    public LuceneMap(File dir) throws IOException {
        this(dir, false);
    }

    public LuceneMap(File path, boolean readOnly) throws IOException {
        this.readOnly = readOnly;
        this.path = path;
    }

    public Directory getDirectory() throws IOException {
        if (this.directory == null) {
            this.directory = FSDirectory.open((File)this.getPath());
        }
        return this.directory;
    }

    public File getPath() throws IOException {
        if (this.path == null) {
            this.path = File.createTempFile("lucene", "");
            this.path.delete();
            this.path.mkdir();
            this.path.deleteOnExit();
        }
        return this.path;
    }

    public synchronized void optimize() throws CorruptIndexException, IOException {
        this.getIndexWriter().optimize();
    }

    @Override
    public synchronized void clear() {
        try {
            this.getIndexWriter().deleteAll();
        }
        catch (Exception e) {
            throw new MatrixException("cannot clear index", e);
        }
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        try {
            Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
            return this.getIndexSearcher().docFreq(term) > 0;
        }
        catch (Exception e) {
            throw new MatrixException("could not search documents: " + key, e);
        }
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        try {
            Term term = new Term(VALUESTRING, LuceneMap.getUniqueString(value));
            return this.getIndexSearcher().docFreq(term) > 0;
        }
        catch (Exception e) {
            throw new MatrixException("could not search documents: " + value, e);
        }
    }

    @Override
    public synchronized V get(Object key) {
        try {
            Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
            TermQuery query = new TermQuery(term);
            TopDocs docs = this.getIndexSearcher().search((Query)query, 1);
            if (docs.totalHits > 0) {
                ScoreDoc match = docs.scoreDocs[0];
                Document doc = this.getIndexSearcher().doc(match.doc);
                return this.getObjectFromBytes(doc.getBinaryValue(VALUEDATA));
            }
        }
        catch (Exception e) {
            throw new MatrixException("could not search documents: " + key, e);
        }
        return null;
    }

    private V getObjectFromBytes(byte[] bytes) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object o = ois.readObject();
            ois.close();
            bis.close();
            return (V)o;
        }
        catch (Exception e) {
            throw new MatrixException("could not convert to object", e);
        }
    }

    @Override
    public synchronized Set<K> keySet() {
        HashSet<V> set = new HashSet<V>();
        if (this.isEmpty()) {
            return set;
        }
        try {
            Term term = new Term(KEYSTRING, "*");
            WildcardQuery query = new WildcardQuery(term);
            TopDocs docs = this.getIndexSearcher().search((Query)query, 1000000);
            ScoreDoc[] scoreDocArray = docs.scoreDocs;
            int n = docs.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc sd = scoreDocArray[n2];
                Document d = this.getIndexSearcher().doc(sd.doc);
                set.add(this.getObjectFromBytes(d.getBinaryValue(KEYDATA)));
                ++n2;
            }
            return set;
        }
        catch (Exception e) {
            throw new MatrixException("could not search documents", e);
        }
    }

    private static String getUniqueString(Object o) throws IOException {
        if (o == null) {
            return "";
        }
        byte[] data = SerializationUtil.serialize((Serializable)o);
        String s = Base64.encodeBytes(data);
        return s;
    }

    @Override
    public synchronized V put(K key, V value) {
        try {
            Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
            Document doc = new Document();
            doc.add((Fieldable)new Field(KEYSTRING, LuceneMap.getUniqueString(key), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field(KEYDATA, this.getBytes(key), Field.Store.YES));
            doc.add((Fieldable)new Field(VALUESTRING, LuceneMap.getUniqueString(value), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field(VALUEDATA, this.getBytes(value), Field.Store.YES));
            this.getIndexWriter().updateDocument(term, doc);
        }
        catch (Exception e) {
            throw new MatrixException("could not add document: " + key, e);
        }
        return null;
    }

    @Override
    public synchronized V remove(Object key) {
        try {
            Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
            this.getIndexWriter().deleteDocuments(term);
        }
        catch (Exception e) {
            throw new MatrixException("could not delete document: " + key, e);
        }
        return null;
    }

    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = new StandardAnalyzer(Version.LUCENE_CURRENT);
        }
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public synchronized int size() {
        try {
            this.flush();
            int size = this.getIndexWriter().numDocs();
            return size;
        }
        catch (Exception e) {
            throw new MatrixException("could not count documents", e);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.getIndexWriter().expungeDeletes(true);
        this.getIndexWriter().commit();
    }

    @Override
    public synchronized void close() throws IOException {
        this.getIndexWriter().close();
    }

    private synchronized IndexWriter getIndexWriter() {
        try {
            if (!this.readOnly && this.indexSearcher != null) {
                this.indexSearcher.close();
                this.indexSearcher = null;
            }
            if (this.indexWriter == null) {
                if (IndexReader.indexExists((Directory)this.getDirectory())) {
                    if (!this.readOnly) {
                        if (IndexWriter.isLocked((Directory)this.getDirectory())) {
                            IndexWriter.unlock((Directory)this.getDirectory());
                        }
                        this.indexWriter = new IndexWriter(this.getDirectory(), this.getAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
                    }
                } else if (!this.readOnly) {
                    this.indexWriter = new IndexWriter(this.getDirectory(), this.getAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
                }
            }
            return this.indexWriter;
        }
        catch (Exception e) {
            throw new MatrixException("could not prepare writher", e);
        }
    }

    private synchronized IndexSearcher getIndexSearcher() {
        try {
            if (!IndexReader.indexExists((Directory)this.getDirectory())) {
                this.getIndexWriter();
            }
            if (this.indexWriter != null) {
                this.flush();
            }
            if (this.indexSearcher != null && !this.indexSearcher.getIndexReader().isCurrent()) {
                this.indexSearcher.close();
                this.indexSearcher = null;
            }
            if (this.indexSearcher == null) {
                this.indexSearcher = new IndexSearcher(this.directory, true);
            }
            return this.indexSearcher;
        }
        catch (Exception e) {
            throw new MatrixException("could not prepare reader", e);
        }
    }

    private byte[] getBytes(Object o) {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bao);
            oos.writeObject(o);
            oos.close();
            bao.close();
            return bao.toByteArray();
        }
        catch (Exception e) {
            throw new MatrixException("could not convert to bytes: " + o, e);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            while (true) {
                Object k = s.readObject();
                Object v = s.readObject();
                this.put(k, v);
            }
        }
        catch (OptionalDataException e) {
            return;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException, MatrixException {
        s.defaultWriteObject();
        for (K k : this.keySet()) {
            V v = this.get(k);
            s.writeObject(k);
            s.writeObject(v);
        }
    }

    @Override
    public synchronized void erase() throws IOException {
        this.close();
        FileUtil.deleteRecursive(this.path);
    }
}

