/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jmatio;

import com.jmatio.types.MLDouble;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLDoubleMatrix
extends AbstractDenseDoubleMatrix
implements Wrapper<MLDouble> {
    private static final long serialVersionUID = 5687213209146399315L;
    private transient MLDouble matrix = null;
    private int[] pack = null;

    public MLDoubleMatrix(Matrix m) {
        if (m.getAnnotation() != null) {
            this.setAnnotation(m.getAnnotation().clone());
            this.matrix = new MLDouble(m.getLabel(), MathUtil.toIntArray(m.getSize()));
        } else {
            this.matrix = new MLDouble("matrix" + System.nanoTime(), MathUtil.toIntArray(m.getSize()));
        }
        this.init();
        for (long[] c : m.availableCoordinates()) {
            this.setAsDouble(m.getAsDouble(c), c);
        }
    }

    public MLDoubleMatrix(long ... size) {
        if (Coordinates.product(size) > 0L) {
            this.matrix = new MLDouble("matrix" + System.nanoTime(), MathUtil.toIntArray(size));
            this.init();
        }
    }

    private void init() {
        int[] dims = this.matrix.getDimensions();
        this.pack = new int[this.matrix.getNDimensions()];
        this.pack[0] = 1;
        int i = 1;
        while (i < this.pack.length) {
            this.pack[i] = dims[i - 1] * this.pack[i - 1];
            ++i;
        }
    }

    int getIndex(long ... coords) {
        int index = 0;
        int x = 0;
        while (x < coords.length) {
            index = (int)((long)index + coords[x] * (long)this.pack[x]);
            ++x;
        }
        return index;
    }

    public MLDoubleMatrix(MLDouble matrix) {
        this.matrix = matrix;
        this.setLabel(matrix.getName());
        this.init();
    }

    @Override
    public long[] getSize() {
        return this.matrix == null ? Coordinates.ZERO2D : MathUtil.toLongArray(this.matrix.getDimensions());
    }

    @Override
    public synchronized double getDouble(long ... coordinates) {
        return (Double)this.matrix.get(this.getIndex(coordinates));
    }

    @Override
    public synchronized void setDouble(double value, long ... coordinates) {
        this.matrix.set((Number)value, this.getIndex(coordinates));
    }

    @Override
    public MLDouble getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(MLDouble object) {
        this.matrix = object;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String name = (String)s.readObject();
        double[][] values = (double[][])s.readObject();
        this.matrix = new MLDouble(name, values);
    }

    private void writeObject(ObjectOutputStream s) throws IOException, MatrixException {
        s.defaultWriteObject();
        s.writeObject(this.matrix.name);
        s.writeObject(this.toDoubleArray());
    }
}

