/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jlinalg;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jlinalg.IRingElement;
import org.jlinalg.IRingElementFactory;
import org.jlinalg.doublewrapper.DoubleWrapper;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLinAlgDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<org.jlinalg.Matrix<DoubleWrapper>> {
    private static final long serialVersionUID = -3223474248020842822L;
    private transient org.jlinalg.Matrix<DoubleWrapper> matrix = null;

    public JLinAlgDenseDoubleMatrix2D(long ... size) {
        this.matrix = new org.jlinalg.Matrix((int)size[0], (int)size[1], (IRingElementFactory)DoubleWrapper.FACTORY);
        for (long[] c : this.availableCoordinates()) {
            this.setAsDouble(0.0, c);
        }
    }

    public JLinAlgDenseDoubleMatrix2D(org.jlinalg.Matrix<DoubleWrapper> m) {
        this.matrix = m;
    }

    public JLinAlgDenseDoubleMatrix2D(Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setAsDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        DoubleWrapper d = (DoubleWrapper)this.matrix.get((int)row + 1, (int)column + 1);
        return d == null ? 0.0 : d.doubleValue();
    }

    @Override
    public double getDouble(int row, int column) {
        DoubleWrapper d = (DoubleWrapper)this.matrix.get(row + 1, column + 1);
        return d == null ? 0.0 : d.doubleValue();
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.getRows(), this.matrix.getCols()};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.set((int)row + 1, (int)column + 1, (IRingElement)new DoubleWrapper(value));
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.set(row + 1, column + 1, (IRingElement)new DoubleWrapper(value));
    }

    @Override
    public org.jlinalg.Matrix<DoubleWrapper> getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(org.jlinalg.Matrix<DoubleWrapper> object) {
        this.matrix = object;
    }

    @Override
    public Matrix transpose() {
        return new JLinAlgDenseDoubleMatrix2D((org.jlinalg.Matrix<DoubleWrapper>)this.matrix.transpose());
    }

    @Override
    public Matrix inv() {
        return new JLinAlgDenseDoubleMatrix2D((org.jlinalg.Matrix<DoubleWrapper>)this.matrix.inverse());
    }

    @Override
    public Matrix plus(double value) {
        return new JLinAlgDenseDoubleMatrix2D((org.jlinalg.Matrix<DoubleWrapper>)this.matrix.add((IRingElement)new DoubleWrapper(value)));
    }

    @Override
    public Matrix times(double value) {
        return new JLinAlgDenseDoubleMatrix2D((org.jlinalg.Matrix<DoubleWrapper>)this.matrix.multiply((IRingElement)new DoubleWrapper(value)));
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof JLinAlgDenseDoubleMatrix2D) {
            org.jlinalg.Matrix<DoubleWrapper> b = ((JLinAlgDenseDoubleMatrix2D)m).getWrappedObject();
            return new JLinAlgDenseDoubleMatrix2D((org.jlinalg.Matrix<DoubleWrapper>)this.matrix.multiply(b));
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix copy() {
        JLinAlgDenseDoubleMatrix2D m = new JLinAlgDenseDoubleMatrix2D((org.jlinalg.Matrix<DoubleWrapper>)this.matrix.copy());
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        double[][] data = (double[][])s.readObject();
        this.matrix = new org.jlinalg.Matrix(data.length, data[0].length, (IRingElementFactory)DoubleWrapper.FACTORY);
        int r = 0;
        while (r < data.length) {
            int c = 0;
            while (c < data[0].length) {
                this.setDouble(data[r][c], r, c);
                ++c;
            }
            ++r;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException, MatrixException {
        s.defaultWriteObject();
        s.writeObject(this.toDoubleArray());
    }
}

