/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jexcelapi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import jxl.Workbook;
import jxl.biff.EmptyCell;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.StringUtil;

public abstract class ExportMatrixXLS {
    public static void toFile(File file, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        try {
            WritableWorkbook writableWorkbook = Workbook.createWorkbook((File)file);
            WritableSheet sheet = writableWorkbook.createSheet("First Sheet", 0);
            for (long[] c : matrix.allCoordinates()) {
                int row = (int)c[0];
                int column = (int)c[1];
                Object o = matrix.getAsObject(c);
                Object cell = null;
                cell = o == null ? new EmptyCell(column, row) : (o instanceof java.lang.Number ? new Number(column, row, ((java.lang.Number)o).doubleValue()) : new Label(column, row, StringUtil.convert(o)));
                sheet.addCell((WritableCell)cell);
            }
            writableWorkbook.write();
            writableWorkbook.close();
        }
        catch (WriteException e) {
            throw new MatrixException("could not save to file " + file, e);
        }
    }

    public static void toStream(OutputStream outputStream, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        try {
            WritableWorkbook writableWorkbook = Workbook.createWorkbook((OutputStream)outputStream);
            WritableSheet sheet = writableWorkbook.createSheet("First Sheet", 0);
            for (long[] c : matrix.allCoordinates()) {
                int row = (int)c[0];
                int column = (int)c[1];
                Object o = matrix.getAsObject(c);
                Object cell = null;
                cell = o == null ? new EmptyCell(column, row) : (o instanceof java.lang.Number ? new Number(column, row, ((java.lang.Number)o).doubleValue()) : new Label(column, row, StringUtil.convert(o)));
                sheet.addCell((WritableCell)cell);
            }
            writableWorkbook.write();
            writableWorkbook.close();
        }
        catch (WriteException e) {
            throw new MatrixException("could not save to stream", e);
        }
    }
}

