/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jama;

import Jama.CholeskyDecomposition;
import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.Matrix;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamaDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<Matrix> {
    private static final long serialVersionUID = -6065454603299978242L;
    private Matrix matrix = null;

    public JamaDenseDoubleMatrix2D(long ... size) {
        this.matrix = new Matrix((int)size[0], (int)size[1]);
    }

    public JamaDenseDoubleMatrix2D(Matrix matrix) {
        this.matrix = matrix;
    }

    public JamaDenseDoubleMatrix2D(org.ujmp.core.Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setAsDouble(source.getAsDouble(c), c);
        }
    }

    public static Matrix identity(int m, int n) {
        Matrix A = new Matrix(m, n);
        double[][] X = A.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                X[i][j] = i == j ? 1.0 : 0.0;
                ++j;
            }
            ++i;
        }
        return A;
    }

    @Override
    public org.ujmp.core.Matrix inv() throws MatrixException {
        return new JamaDenseDoubleMatrix2D(this.matrix.inverse());
    }

    @Override
    public org.ujmp.core.Matrix[] svd() throws MatrixException {
        if (this.getColumnCount() > this.getRowCount()) {
            SingularValueDecomposition svd = new SingularValueDecomposition(this.matrix.transpose());
            JamaDenseDoubleMatrix2D u = new JamaDenseDoubleMatrix2D(svd.getV());
            JamaDenseDoubleMatrix2D s = new JamaDenseDoubleMatrix2D(svd.getS().transpose());
            JamaDenseDoubleMatrix2D v = new JamaDenseDoubleMatrix2D(svd.getU());
            return new org.ujmp.core.Matrix[]{u, s, v};
        }
        SingularValueDecomposition svd = new SingularValueDecomposition(this.matrix);
        JamaDenseDoubleMatrix2D u = new JamaDenseDoubleMatrix2D(svd.getU());
        JamaDenseDoubleMatrix2D s = new JamaDenseDoubleMatrix2D(svd.getS());
        JamaDenseDoubleMatrix2D v = new JamaDenseDoubleMatrix2D(svd.getV());
        return new org.ujmp.core.Matrix[]{u, s, v};
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.get((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.get(row, column);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.getRowDimension(), this.matrix.getColumnDimension()};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.set((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.set(row, column, value);
    }

    @Override
    public Matrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(Matrix object) {
        this.matrix = object;
    }

    @Override
    public final org.ujmp.core.Matrix copy() throws MatrixException {
        JamaDenseDoubleMatrix2D m = new JamaDenseDoubleMatrix2D(this.matrix.copy());
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    @Override
    public org.ujmp.core.Matrix transpose() {
        return new JamaDenseDoubleMatrix2D(this.matrix.transpose());
    }

    @Override
    public org.ujmp.core.Matrix[] qr() {
        if (this.getRowCount() >= this.getColumnCount()) {
            QRDecomposition qr = new QRDecomposition(this.matrix);
            JamaDenseDoubleMatrix2D q = new JamaDenseDoubleMatrix2D(qr.getQ());
            JamaDenseDoubleMatrix2D r = new JamaDenseDoubleMatrix2D(qr.getR());
            return new org.ujmp.core.Matrix[]{q, r};
        }
        throw new MatrixException("QR decomposition only works for matrices m>=n");
    }

    @Override
    public org.ujmp.core.Matrix[] lu() {
        LUDecomposition lu = new LUDecomposition(this.matrix);
        JamaDenseDoubleMatrix2D l = new JamaDenseDoubleMatrix2D(lu.getL());
        JamaDenseDoubleMatrix2D u = new JamaDenseDoubleMatrix2D(lu.getU());
        int m = (int)this.getRowCount();
        int[] piv = lu.getPivot();
        JamaDenseDoubleMatrix2D p = new JamaDenseDoubleMatrix2D(m, m);
        int i = 0;
        while (i < m) {
            p.setAsDouble(1.0, new long[]{i, piv[i]});
            ++i;
        }
        return new org.ujmp.core.Matrix[]{l, u, p};
    }

    @Override
    public org.ujmp.core.Matrix[] eig() {
        EigenvalueDecomposition eig = new EigenvalueDecomposition(this.matrix);
        JamaDenseDoubleMatrix2D v = new JamaDenseDoubleMatrix2D(eig.getV());
        JamaDenseDoubleMatrix2D d = new JamaDenseDoubleMatrix2D(eig.getD());
        return new org.ujmp.core.Matrix[]{v, d};
    }

    @Override
    public org.ujmp.core.Matrix chol() {
        CholeskyDecomposition chol = new CholeskyDecomposition(this.matrix);
        JamaDenseDoubleMatrix2D r = new JamaDenseDoubleMatrix2D(chol.getL());
        return r;
    }

    @Override
    public org.ujmp.core.Matrix mtimes(org.ujmp.core.Matrix m) {
        if (m instanceof JamaDenseDoubleMatrix2D) {
            return new JamaDenseDoubleMatrix2D(this.matrix.times(((JamaDenseDoubleMatrix2D)m).matrix));
        }
        return super.mtimes(m);
    }

    @Override
    public org.ujmp.core.Matrix times(double value) {
        return new JamaDenseDoubleMatrix2D(this.matrix.times(value));
    }

    @Override
    public org.ujmp.core.Matrix divide(double value) {
        return new JamaDenseDoubleMatrix2D(this.matrix.times(1.0 / value));
    }

    @Override
    public double det() {
        return this.matrix.det();
    }

    @Override
    public org.ujmp.core.Matrix plus(org.ujmp.core.Matrix m) {
        if (m instanceof JamaDenseDoubleMatrix2D) {
            return new JamaDenseDoubleMatrix2D(this.matrix.plus(((JamaDenseDoubleMatrix2D)m).matrix));
        }
        return super.plus(m);
    }

    @Override
    public org.ujmp.core.Matrix minus(org.ujmp.core.Matrix m) {
        if (m instanceof JamaDenseDoubleMatrix2D) {
            return new JamaDenseDoubleMatrix2D(this.matrix.minus(((JamaDenseDoubleMatrix2D)m).matrix));
        }
        return super.minus(m);
    }

    @Override
    public org.ujmp.core.Matrix solve(org.ujmp.core.Matrix b) {
        if (b instanceof JamaDenseDoubleMatrix2D) {
            JamaDenseDoubleMatrix2D b2 = (JamaDenseDoubleMatrix2D)b;
            Matrix x = this.matrix.solve(b2.matrix);
            return new JamaDenseDoubleMatrix2D(x);
        }
        return super.solve(b);
    }
}

