/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ujmp.core.util.io.BufferedRandomAccessFile;

public class SeekableLineInputStream
extends InputStream {
    private int bufferSize = 65536;
    private BufferedRandomAccessFile in = null;
    private final List<Long> lineEnds = new ArrayList<Long>();

    public SeekableLineInputStream(String file) throws IOException {
        this(new File(file));
    }

    public SeekableLineInputStream(File file) throws IOException {
        this.in = new BufferedRandomAccessFile(file, "r", this.bufferSize);
        long totalLength = this.in.length();
        long maxLength = 0L;
        long last = -1L;
        byte[] bytes = new byte[this.bufferSize];
        long pos = 0L;
        while (pos < totalLength) {
            Arrays.fill(bytes, (byte)0);
            this.in.read(pos, bytes);
            int i = 0;
            while (i < this.bufferSize) {
                byte b = bytes[i];
                if (b == 10) {
                    long length = pos + (long)i - last;
                    if (length > maxLength) {
                        maxLength = length;
                    }
                    this.lineEnds.add(pos + (long)i);
                    last = pos + (long)i;
                }
                ++i;
            }
            pos += (long)this.bufferSize;
        }
        this.lineEnds.remove(totalLength - 1L);
        System.out.println("This stream has " + this.getLineCount() + " lines");
        if (maxLength + 1L > (long)this.bufferSize) {
            this.bufferSize = (int)maxLength + 1;
            this.in.close();
            this.in = new BufferedRandomAccessFile(file, "r", this.bufferSize);
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int getLineCount() {
        return this.lineEnds.size() + 1;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public String readLine(int lineNumber) throws IOException {
        String line = null;
        if (line == null) {
            long start = 0L;
            if (lineNumber > 0) {
                start = this.lineEnds.get(lineNumber - 1) + 1L;
            }
            long end = 0L;
            end = lineNumber < this.getLineCount() - 1 ? this.lineEnds.get(lineNumber).longValue() : this.in.length();
            int length = (int)(end - start);
            byte[] bytes = new byte[length];
            this.in.read(start, bytes);
            line = bytes[bytes.length - 1] == 13 ? new String(bytes, 0, bytes.length - 1) : new String(bytes);
        }
        return line;
    }
}

