/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.concurrent;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.ujmp.core.util.concurrent.UJMPThreadPoolExecutor;

public abstract class PForEquidistant {
    private static final ThreadLocal<ThreadPoolExecutor> executors = new ThreadLocal();
    private static final ThreadLocal<List<Future<Object>>> futures = new ThreadLocal();
    private Object[] objects = null;
    private static int processors = 2;

    static {
        try {
            processors = Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public PForEquidistant(int threads, int first, int last, Object ... objects) {
        this.objects = objects;
        if (threads < 2) {
            int i = first;
            while (i <= last) {
                this.step(i);
                ++i;
            }
        } else {
            ThreadPoolExecutor es = executors.get();
            if (es == null) {
                es = new UJMPThreadPoolExecutor(this.getClass().getName(), threads, threads);
                executors.set(es);
            } else {
                es.setCorePoolSize(threads);
                es.setMaximumPoolSize(threads);
            }
            List<Future<Object>> list = futures.get();
            if (list == null) {
                list = new LinkedList<Future<Object>>();
                futures.set(list);
            }
            int i = 0;
            while (i < threads) {
                list.add(es.submit(new StepCallable(first + i, last, threads)));
                ++i;
            }
            for (Future<Object> f : list) {
                try {
                    f.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            list.clear();
            es.setCorePoolSize(0);
        }
    }

    public PForEquidistant(int first, int last, Object ... objects) {
        this(processors, first, last, objects);
    }

    public abstract void step(int var1);

    public final Object getObject(int i) {
        return this.objects[i];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StepCallable
    implements Callable<Object> {
        private int first = 0;
        private int last = 0;
        private int stepsize = 0;

        public StepCallable(int first, int last, int stepsize) {
            this.first = first;
            this.last = last;
            this.stepsize = stepsize;
        }

        @Override
        public Object call() throws Exception {
            try {
                int i = this.first;
                while (i <= this.last) {
                    PForEquidistant.this.step(i);
                    i += this.stepsize;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

