/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.setmatrix;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.genericmatrix.stub.AbstractDenseGenericMatrix2D;
import org.ujmp.core.setmatrix.SetMatrix;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSetMatrix<A>
extends AbstractDenseGenericMatrix2D<A>
implements SetMatrix<A> {
    private static final long serialVersionUID = -3152489258987719660L;

    public abstract Set<A> getSet();

    @Override
    public final long[] getSize() {
        return new long[]{this.size(), 1L};
    }

    @Override
    public boolean add(A e) {
        boolean ret = this.getSet().add(e);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        boolean ret = this.getSet().addAll(c);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public boolean contains(Object o) {
        return this.getSet().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getSet().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.getSet().isEmpty();
    }

    @Override
    public Iterator<A> iterator() {
        return this.getSet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = this.getSet().remove(o);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = this.getSet().removeAll(c);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = this.getSet().retainAll(c);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public int size() {
        return this.getSet().size();
    }

    @Override
    public A getObject(long row, long column) {
        return this.getObject((int)row, (int)column);
    }

    @Override
    public A getObject(int row, int column) {
        Iterator<A> it = this.getSet().iterator();
        int i = 0;
        while (i < row && it.hasNext()) {
            it.next();
            ++i;
        }
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    public void setObject(A value, long row, long column) {
        throw new MatrixException("modifications are only allowed over Set<?> interface");
    }

    @Override
    public void setObject(A value, int row, int column) {
        throw new MatrixException("modifications are only allowed over Set<?> interface");
    }

    @Override
    public Object[] toArray() {
        return this.getSet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getSet().toArray(a);
    }

    @Override
    public double getAsDouble(long ... coordinates) throws MatrixException {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public void setAsDouble(double value, long ... coordinates) throws MatrixException {
        this.setAsObject(value, coordinates);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT;
    }

    @Override
    public final Matrix.StorageType getStorageType() {
        return Matrix.StorageType.SET;
    }

    @Override
    public final void clear() {
        this.getSet().clear();
    }
}

