/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.mapmatrix.AbstractMapMatrix;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMatrix
extends AbstractMapMatrix<String, Object> {
    private static final long serialVersionUID = 7869997158743678080L;
    public static final String CONTENT = "Content";
    public static final String TEXT = "Text";
    public static final String ID = "Id";
    public static final String BYTES = "Bytes";
    public static final String SIZE = "Size";
    public static final String CANREAD = "CanRead";
    public static final String CANWRITE = "CanWrite";
    public static final String ISHIDDEN = "IsHidden";
    public static final String ISFILE = "IsFile";
    public static final String ISDIRECTORY = "IsDirectory";
    public static final String LASTMODIFIED = "LastModified";
    public static final String FILENAME = "FileName";
    public static final String CANEXECUTE = "CanExecute";
    public static final String PATH = "Path";
    public static final String EXTENSION = "Extension";
    public static final String FILEFORMAT = "FileFormat";
    public static final String MD5 = "MD5";
    private Map<String, Object> map = null;

    public FileMatrix(File file, Object ... parameters) throws IOException {
        this.map = new FileMap(file, parameters);
    }

    public FileMatrix(FileFormat fileFormat, File file, Object ... parameters) throws IOException {
        this.map = new FileMap(fileFormat, file, parameters);
    }

    @Override
    public Map<String, Object> getMap() {
        return this.map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileMap
    implements Map<String, Object>,
    Serializable {
        private static final long serialVersionUID = -4946966403241068247L;
        private File file = null;
        private Map<String, Object> map = null;
        private transient SoftReference<Matrix> content = null;
        private transient SoftReference<Matrix> bytes = null;
        private FileFormat fileformat = null;
        private Object[] parameters = null;

        public FileMap(File file, Object ... paramegters) throws IOException {
            this(null, file, paramegters);
        }

        public FileMap(FileFormat fileFormat, File file, Object ... paramegters) throws IOException {
            this.fileformat = fileFormat == null ? FileFormat.guess(file) : fileFormat;
            this.parameters = paramegters;
            this.file = file;
            this.map = new HashMap<String, Object>();
            this.content = new SoftReference<Object>(null);
            this.map.put(FileMatrix.CONTENT, null);
            this.map.put(FileMatrix.MD5, null);
            this.map.put(FileMatrix.ID, file.getAbsolutePath());
            this.map.put(FileMatrix.PATH, file.getPath());
            this.map.put(FileMatrix.FILENAME, file.getName());
            this.map.put(FileMatrix.BYTES, null);
            String[] components = file.getName().split("\\.");
            if (components.length > 1) {
                this.map.put(FileMatrix.EXTENSION, components[components.length - 1]);
            } else {
                this.map.put(FileMatrix.EXTENSION, null);
            }
            this.map.put(FileMatrix.CANREAD, file.canRead());
            this.map.put(FileMatrix.CANWRITE, file.canWrite());
            this.map.put(FileMatrix.ISHIDDEN, file.isHidden());
            this.map.put(FileMatrix.ISDIRECTORY, file.isDirectory());
            this.map.put(FileMatrix.ISFILE, file.isFile());
            this.map.put(FileMatrix.LASTMODIFIED, file.lastModified());
            this.map.put(FileMatrix.SIZE, file.length());
            this.map.put(FileMatrix.FILEFORMAT, (Object)this.fileformat);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new MatrixException("not implemented");
        }

        @Override
        public Object get(Object key) {
            if (FileMatrix.CONTENT.equals(key)) {
                if (this.fileformat == null) {
                    return null;
                }
                Matrix m = null;
                if (this.content == null || this.content.get() == null) {
                    try {
                        m = MatrixFactory.linkToFile(this.fileformat, this.file, this.parameters);
                        this.content = new SoftReference<Matrix>(m);
                    }
                    catch (Exception e) {
                        throw new MatrixException(e);
                    }
                }
                return this.content.get();
            }
            if (FileMatrix.MD5.equals(key)) {
                String md5 = (String)this.map.get(FileMatrix.MD5);
                if (md5 == null) {
                    try {
                        md5 = MathUtil.getMD5Sum(this.file);
                        this.map.put((String)key, md5);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return md5;
            }
            if (FileMatrix.BYTES.equals(key)) {
                if (this.bytes == null || this.bytes.get() == null) {
                    try {
                        this.bytes = new SoftReference<Matrix>(MatrixFactory.linkToFile(FileFormat.RAW, this.file, new Object[0]));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return this.bytes.get();
            }
            return this.map.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public Object put(String key, Object value) {
            return this.map.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            this.map.putAll(m);
        }

        @Override
        public Object remove(Object key) {
            return this.map.remove(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Collection<Object> values() {
            throw new MatrixException("not implemented");
        }
    }
}

