/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.io.Flushable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.impl.DefaultSparseObjectMatrix;
import org.ujmp.core.objectmatrix.impl.EmptyObject;
import org.ujmp.core.objectmatrix.impl.VolatileSparseObjectMatrix;
import org.ujmp.core.objectmatrix.stub.AbstractObjectMatrix;

public class BufferedObjectMatrix
extends AbstractObjectMatrix
implements Flushable {
    private static final long serialVersionUID = 7750549087897737457L;
    private Matrix inputBuffer = null;
    private Set<Coordinates> outputBuffer = null;
    private int outputBufferSize = Integer.MAX_VALUE;
    private Matrix original = null;
    private Thread writeThread = null;
    private static final EmptyObject EMPTYOBJECT = new EmptyObject();

    public BufferedObjectMatrix(Matrix original) {
        this.original = original;
        this.setInputBufferSize(0);
        this.setOutputBufferSize(Integer.MAX_VALUE);
        this.writeThread = new WriteThread();
        this.writeThread.start();
    }

    public BufferedObjectMatrix(Matrix original, int outputBufferSize) {
        this.original = original;
        this.setInputBufferSize(0);
        this.setOutputBufferSize(outputBufferSize);
    }

    public BufferedObjectMatrix(Matrix original, int outputBufferSize, int inputBufferSize) {
        this.original = original;
        this.setInputBufferSize(inputBufferSize);
        this.setOutputBufferSize(outputBufferSize);
    }

    public synchronized long[] getSize() {
        return this.inputBuffer.getSize();
    }

    public synchronized Object getObject(long ... coordinates) throws MatrixException {
        Object o = null;
        o = this.inputBuffer.getAsObject(coordinates);
        if (o == null) {
            o = this.original.getAsObject(coordinates);
            if (o == null) {
                this.inputBuffer.setAsObject(EMPTYOBJECT, coordinates);
            } else {
                this.inputBuffer.setAsObject(o, coordinates);
            }
        } else if (o == EMPTYOBJECT) {
            return null;
        }
        return o;
    }

    public synchronized long getValueCount() {
        return this.original.getValueCount();
    }

    public final Matrix.StorageType getStorageType() {
        return this.inputBuffer.getStorageType();
    }

    public synchronized void setObject(Object value, long ... coordinates) throws MatrixException {
        this.inputBuffer.setAsObject(value, coordinates);
        this.outputBuffer.add(new Coordinates(coordinates));
    }

    public synchronized void setInputBufferSize(int numElements) {
        this.inputBuffer = numElements < 1 ? new VolatileSparseObjectMatrix(this.original.getSize()) : new DefaultSparseObjectMatrix(numElements, this.original.getSize());
    }

    public synchronized void setOutputBufferSize(int numElements) {
        try {
            this.flush();
            this.outputBuffer = Collections.synchronizedSet(new HashSet());
            this.outputBufferSize = numElements;
        }
        catch (IOException e) {
            throw new MatrixException("could not set output buffer", e);
        }
    }

    public synchronized void flush() throws IOException {
        while (this.outputBuffer != null && this.outputBuffer.size() != 0) {
            try {
                this.outputBuffer.wait();
            }
            catch (InterruptedException e) {
                throw new MatrixException("could not flush buffer", e);
            }
        }
    }

    public synchronized int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public boolean contains(long ... coordinates) {
        return this.inputBuffer.contains(coordinates) || this.original.contains(coordinates);
    }

    public boolean isReadOnly() {
        return this.original.isReadOnly();
    }

    class WriteThread
    extends Thread {
        WriteThread() {
        }

        public void run() {
            try {
                while (true) {
                    if (BufferedObjectMatrix.this.outputBuffer != null && !BufferedObjectMatrix.this.outputBuffer.isEmpty()) {
                        Coordinates c = (Coordinates)BufferedObjectMatrix.this.outputBuffer.iterator().next();
                        BufferedObjectMatrix.this.outputBuffer.remove(c);
                        double value = BufferedObjectMatrix.this.inputBuffer.getAsDouble(c.dimensions);
                        BufferedObjectMatrix.this.original.setAsDouble(value, c.dimensions);
                        continue;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                throw new MatrixException("error writing to matrix", e);
            }
        }
    }
}

