/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

public class Join
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -4037364843847848445L;
    private Matrix result = null;
    private long column1 = 0L;
    private long column2 = 0L;

    public Join(Matrix m1, Matrix m2, long column1, long column2) {
        super(m1, m2);
        this.column1 = column1;
        this.column2 = column2;
    }

    public Object getObject(long ... coordinates) throws MatrixException {
        if (this.result == null) {
            this.createMatrix();
        }
        return this.result.getAsObject(coordinates);
    }

    public long[] getSize() {
        if (this.result == null) {
            this.createMatrix();
        }
        return this.result.getSize();
    }

    private void createMatrix() {
        List list;
        Object o;
        Matrix m1 = this.getSource();
        Matrix m2 = this.getSources()[1];
        HashMap<Object, LinkedList<Long>> right = new HashMap<Object, LinkedList<Long>>();
        long r = 0L;
        while (r < m2.getRowCount()) {
            o = m2.getAsObject(r, this.column2);
            list = (LinkedList<Long>)right.get(o);
            if (list == null) {
                list = new LinkedList<Long>();
                right.put(o, (LinkedList<Long>)list);
            }
            list.add(r);
            ++r;
        }
        this.result = MatrixFactory.dense(this.getValueType(), m1.getRowCount(), m1.getColumnCount() + m2.getColumnCount());
        for (long[] c : m1.allCoordinates()) {
            this.result.setAsObject(m1.getAsObject(c), c);
        }
        r = 0L;
        while (r < m1.getRowCount()) {
            o = m1.getAsObject(r, this.column1);
            list = (List)right.get(o);
            if (list != null) {
                long row2 = (Long)list.iterator().next();
                long c = 0L;
                while (c < m2.getColumnCount()) {
                    this.result.setAsObject(m2.getAsObject(row2, c), r, c + m1.getColumnCount());
                    ++c;
                }
            }
            ++r;
        }
    }

    public static void main(String[] args) throws Exception {
        Matrix m1 = MatrixFactory.importFromFile(FileFormat.CSV, new File("c:/Documents and Settings/holger/Desktop/original.log"), "\t");
        Matrix m2 = MatrixFactory.importFromFile(FileFormat.CSV, new File("c:/Documents and Settings/holger/Desktop/js.log"), "\t");
        new Join(m1, m2, 3L, 3L).calc(Calculation.Ret.NEW).exportToFile("c:/test.txt", new Object[0]);
    }
}

